/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.auth;

import org.beangle.security.auth.AuthenticationManager;
import org.beangle.security.core.Authentication;
import org.beangle.security.core.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticationManager
implements AuthenticationManager {
    private boolean clearExtraInfo = false;
    protected Logger logger = LoggerFactory.getLogger(AbstractAuthenticationManager.class);

    @Override
    public final Authentication authenticate(Authentication authRequest) throws AuthenticationException {
        try {
            Authentication auth = this.doAuthentication(authRequest);
            this.logger.debug("Successfully Authenticated: {}", (Object)auth);
            return auth;
        }
        catch (AuthenticationException e) {
            e.setAuthentication(authRequest);
            if (this.clearExtraInfo) {
                e.clearExtraInfo();
            }
            throw e;
        }
    }

    protected abstract Authentication doAuthentication(Authentication var1) throws AuthenticationException;

    public void setClearExtraInfo(boolean clearExtraInfo) {
        this.clearExtraInfo = clearExtraInfo;
    }
}

