/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.auth;

import java.util.Iterator;
import java.util.List;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.security.auth.AbstractAuthentication;
import org.beangle.security.auth.AbstractAuthenticationManager;
import org.beangle.security.auth.AccountStatusException;
import org.beangle.security.auth.AuthenticationProvider;
import org.beangle.security.auth.ProviderNotFoundException;
import org.beangle.security.core.Authentication;
import org.beangle.security.core.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderManager
extends AbstractAuthenticationManager
implements Initializing {
    protected final Logger logger = LoggerFactory.getLogger(ProviderManager.class);
    protected List<AuthenticationProvider> providers = CollectUtils.newArrayList();

    public void init() throws Exception {
        if (this.providers.isEmpty()) {
            throw new RuntimeException("authentication provider list is empty");
        }
        this.logger.info("providers:" + this.providers);
    }

    @Override
    public Authentication doAuthentication(Authentication auth) throws AuthenticationException {
        Iterator<AuthenticationProvider> iter = this.getProviders().iterator();
        Class<?> toTest = auth.getClass();
        AuthenticationException lastException = null;
        while (iter.hasNext()) {
            Authentication result;
            AuthenticationProvider provider = iter.next();
            if (!provider.supports(toTest)) continue;
            try {
                result = provider.authenticate(auth);
                if (result != null) {
                    this.copyDetails(auth, result);
                }
            }
            catch (AuthenticationException ae) {
                lastException = ae;
                result = null;
            }
            if (lastException instanceof AccountStatusException) break;
            if (null == result) continue;
            return result;
        }
        if (lastException == null) {
            lastException = new ProviderNotFoundException("Provider not found!");
        }
        throw lastException;
    }

    private void copyDetails(Authentication source, Authentication dest) {
        if (dest instanceof AbstractAuthentication && dest.getDetails() == null) {
            AbstractAuthentication token = (AbstractAuthentication)dest;
            token.setDetails(source.getDetails());
        }
    }

    public List<AuthenticationProvider> getProviders() {
        return this.providers;
    }

    public void setProviders(List<AuthenticationProvider> providers) {
        this.providers = providers;
    }
}

