/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.auth.dao;

import org.beangle.security.auth.BadCredentialsException;
import org.beangle.security.auth.dao.AbstractUserDetailAuthenticationProvider;
import org.beangle.security.auth.encoding.PasswordEncoder;
import org.beangle.security.core.Authentication;
import org.beangle.security.core.AuthenticationException;
import org.beangle.security.core.userdetail.UserDetail;
import org.beangle.security.core.userdetail.UserDetailService;

public class DaoAuthenticationProvider
extends AbstractUserDetailAuthenticationProvider {
    private PasswordEncoder passwordEncoder;
    private UserDetailService userDetailService;

    @Override
    protected void additionalAuthenticationChecks(UserDetail user, Authentication auth) throws AuthenticationException {
        if (!this.passwordEncoder.isPasswordValid(user.getPassword(), (String)auth.getCredentials())) {
            throw new BadCredentialsException();
        }
    }

    @Override
    protected UserDetail retrieveUser(String username, Authentication authentication) throws AuthenticationException {
        return this.userDetailService.loadDetail(username);
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public UserDetailService getUserDetailService() {
        return this.userDetailService;
    }

    public void setUserDetailService(UserDetailService userDetailService) {
        this.userDetailService = userDetailService;
    }
}

