/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.codec;

import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class SymmetricEncryptHelper {
    private Cipher enCipher;
    private Cipher deCipher;
    private String algorithm;

    public SymmetricEncryptHelper(byte[] key) {
        this(key, "DES");
    }

    public SymmetricEncryptHelper(byte[] key, String algorithm) {
        this.algorithm = algorithm;
        SecureRandom sr = new SecureRandom();
        try {
            DESKeySpec dks = new DESKeySpec(key);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
            SecretKey secretKey = keyFactory.generateSecret(dks);
            this.enCipher = Cipher.getInstance(algorithm);
            this.deCipher = Cipher.getInstance(algorithm);
            this.enCipher.init(1, (Key)secretKey, sr);
            this.deCipher.init(2, (Key)secretKey, sr);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public byte[] encypt(byte[] value) {
        try {
            return this.enCipher.doFinal(value);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public byte[] decrypt(byte[] value) {
        try {
            return this.deCipher.doFinal(value);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static String toHexString(byte[] value) {
        String newString = "";
        for (int i = 0; i < value.length; ++i) {
            byte b = value[i];
            String str = Integer.toHexString(b);
            if (str.length() > 2) {
                str = str.substring(str.length() - 2);
            }
            if (str.length() < 2) {
                str = "0" + str;
            }
            newString = newString + str;
        }
        return newString.toUpperCase();
    }

    public static byte[] fromHexString(String value) {
        byte[] rs = new byte[value.length() / 2];
        for (int i = 0; i < value.length(); i += 2) {
            String b = value.substring(i, i + 2);
            rs[i / 2] = Integer.valueOf(b, 16).byteValue();
        }
        return rs;
    }

    public static byte[] encypt(byte[] key, byte[] value) {
        return new SymmetricEncryptHelper(key).encypt(value);
    }

    public static byte[] decrypt(byte[] key, byte[] value) {
        return new SymmetricEncryptHelper(key).decrypt(value);
    }
}

