/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.core.context;

import java.lang.reflect.Constructor;
import org.beangle.commons.lang.Throwables;
import org.beangle.security.core.context.GlobalHolderStrategy;
import org.beangle.security.core.context.InheritableThreadLocalHolderStrategy;
import org.beangle.security.core.context.SecurityContext;
import org.beangle.security.core.context.SecurityContextHolderStrategy;
import org.beangle.security.core.context.ThreadLocalHolderStrategy;

public class SecurityContextHolder {
    public static final String MODE_THREADLOCAL = "MODE_THREADLOCAL";
    public static final String MODE_INHERITABLETHREADLOCAL = "MODE_INHERITABLETHREADLOCAL";
    public static final String MODE_GLOBAL = "MODE_GLOBAL";
    public static final String SYSTEM_PROPERTY = "beangle.security.strategy";
    private static String strategyName = System.getProperty("beangle.security.strategy");
    private static SecurityContextHolderStrategy strategy;
    private static int initializeCount;

    public static void clearContext() {
        strategy.clearContext();
    }

    public static SecurityContext getContext() {
        return strategy.getContext();
    }

    public static int getInitializeCount() {
        return initializeCount;
    }

    private static void initialize() {
        if (strategyName == null || "".equals(strategyName)) {
            strategyName = MODE_THREADLOCAL;
        }
        if (strategyName.equals(MODE_THREADLOCAL)) {
            strategy = new ThreadLocalHolderStrategy();
        } else if (strategyName.equals(MODE_INHERITABLETHREADLOCAL)) {
            strategy = new InheritableThreadLocalHolderStrategy();
        } else if (strategyName.equals(MODE_GLOBAL)) {
            strategy = new GlobalHolderStrategy();
        } else {
            try {
                Class<?> clazz = Class.forName(strategyName);
                Constructor<?> customStrategy = clazz.getConstructor(new Class[0]);
                strategy = (SecurityContextHolderStrategy)customStrategy.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                Throwables.propagate((Throwable)ex);
            }
        }
        ++initializeCount;
    }

    public static void setContext(SecurityContext context) {
        strategy.setContext(context);
    }

    public static void setStrategyName(String strategyName) {
        SecurityContextHolder.strategyName = strategyName;
        SecurityContextHolder.initialize();
    }

    public String toString() {
        return "SecurityContextHolder[strategy='" + strategyName + "'; initializeCount=" + initializeCount + "]";
    }

    static {
        initializeCount = 0;
        SecurityContextHolder.initialize();
    }
}

