/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.core.session.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.Objects;
import org.beangle.security.core.Authentication;
import org.beangle.security.core.session.SessionController;
import org.beangle.security.core.session.SessionException;
import org.beangle.security.core.session.SessionRegistry;
import org.beangle.security.core.session.SessionStatus;
import org.beangle.security.core.session.Sessioninfo;
import org.beangle.security.core.session.SessioninfoBuilder;
import org.beangle.security.core.session.impl.SimpleSessioninfoBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemSessionRegistry
implements SessionRegistry,
Initializing {
    protected static final Logger logger = LoggerFactory.getLogger(MemSessionRegistry.class);
    private SessionController controller;
    private SessioninfoBuilder sessioninfoBuilder = new SimpleSessioninfoBuilder();
    protected Map<String, Set<String>> principals = new ConcurrentHashMap<String, Set<String>>();
    protected Map<String, Sessioninfo> sessionids = new ConcurrentHashMap<String, Sessioninfo>();

    public void init() throws Exception {
        Assert.notNull((Object)this.controller, (String)"controller must set", (Object[])new Object[0]);
        Assert.notNull((Object)this.sessioninfoBuilder, (String)"sessioninfoBuilder must set", (Object[])new Object[0]);
    }

    @Override
    public boolean isRegisted(String principal) {
        Set<String> sessionsUsedByPrincipal = this.principals.get(principal);
        return null != sessionsUsedByPrincipal && !sessionsUsedByPrincipal.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Sessioninfo> getSessioninfos(String principal, boolean includeExpiredSessions) {
        Set<String> sessionsUsedByPrincipal = this.principals.get(principal);
        List list = CollectUtils.newArrayList();
        if (null == sessionsUsedByPrincipal) {
            return list;
        }
        Set<String> set = sessionsUsedByPrincipal;
        synchronized (set) {
            for (String sessionid : sessionsUsedByPrincipal) {
                Sessioninfo info = this.getSessioninfo(sessionid);
                if (info == null || !includeExpiredSessions && info.isExpired()) continue;
                list.add(info);
            }
        }
        return list;
    }

    @Override
    public Sessioninfo getSessioninfo(String sessionid) {
        return this.sessionids.get(sessionid);
    }

    @Override
    public void register(Authentication auth, String sessionid) throws SessionException {
        Sessioninfo existed = this.getSessioninfo(sessionid);
        String principal = auth.getName();
        if (null != existed && Objects.equals((Object)existed.getUsername(), (Object)principal)) {
            return;
        }
        boolean success = this.controller.onRegister(auth, sessionid, this);
        if (!success) {
            throw new SessionException("security.OvermaxSession");
        }
        if (null != existed) {
            existed.addRemark(" expired with replacement.");
            this.remove(sessionid);
        }
        this.sessionids.put(sessionid, this.sessioninfoBuilder.build(auth, sessionid));
        Set<String> sessionsUsedByPrincipal = this.principals.get(principal);
        if (sessionsUsedByPrincipal == null) {
            sessionsUsedByPrincipal = Collections.synchronizedSet(new HashSet(4));
            this.principals.put(principal, sessionsUsedByPrincipal);
        }
        sessionsUsedByPrincipal.add(sessionid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sessioninfo remove(String sessionid) {
        Sessioninfo info = this.getSessioninfo(sessionid);
        if (null == info) {
            return null;
        }
        this.sessionids.remove(sessionid);
        String principal = info.getUsername();
        logger.debug("Remove session {} for {}", (Object)sessionid, (Object)principal);
        Set<String> sessionsUsedByPrincipal = this.principals.get(principal);
        if (null != sessionsUsedByPrincipal) {
            Set<String> set = sessionsUsedByPrincipal;
            synchronized (set) {
                sessionsUsedByPrincipal.remove(sessionid);
                if (sessionsUsedByPrincipal.size() == 0) {
                    this.principals.remove(principal);
                    logger.debug("Remove principal {} from registry", (Object)principal);
                }
            }
        }
        this.controller.onLogout(info);
        return info;
    }

    @Override
    public boolean expire(String sessionid) {
        Sessioninfo info = this.getSessioninfo(sessionid);
        if (null != info) {
            info.expireNow();
        }
        return true;
    }

    @Override
    public SessionStatus getSessionStatus(String sessionid) {
        Sessioninfo info = this.getSessioninfo(sessionid);
        if (null == info) {
            return null;
        }
        return new SessionStatus(info);
    }

    @Override
    public int count() {
        return this.sessionids.size();
    }

    public void setController(SessionController controller) {
        this.controller = controller;
    }

    @Override
    public SessionController getController() {
        return this.controller;
    }

    public void setSessioninfoBuilder(SessioninfoBuilder sessioninfoBuilder) {
        this.sessioninfoBuilder = sessioninfoBuilder;
    }

    public SessioninfoBuilder getSessioninfoBuilder() {
        return this.sessioninfoBuilder;
    }

    @Override
    public void access(String sessionid, long beginAt) {
    }
}

