/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.core.session.impl;

import java.util.Date;
import org.beangle.security.core.session.Sessioninfo;
import org.beangle.security.core.session.category.CategorySessioninfo;

class SimpleSessioninfo
implements CategorySessioninfo {
    private String id;
    private String username;
    private String fullname;
    private String category;
    private Date loginAt;
    private Date expiredAt;
    private Date lastAccessAt;
    private String remark;
    private String server;

    public SimpleSessioninfo() {
    }

    public SimpleSessioninfo(String id, String username, String fullname) {
        this.id = id;
        this.username = username;
        this.fullname = fullname;
        this.loginAt = new Date(System.currentTimeMillis());
    }

    public String toString() {
        String str = " User:[" + this.getUsername() + "]";
        long onlineTime = System.currentTimeMillis() - this.loginAt.getTime();
        long minute = onlineTime / 1000L / 60L;
        long second = onlineTime / 1000L % 60L;
        str = str + "OnLine time:[" + minute + " minute " + second + " second]";
        return str;
    }

    @Override
    public Sessioninfo addRemark(String added) {
        this.remark = null == this.remark ? added : this.remark + added;
        return this;
    }

    @Override
    public long getOnlineTime() {
        if (null == this.expiredAt) {
            return System.currentTimeMillis() - this.loginAt.getTime();
        }
        return this.expiredAt.getTime() - this.loginAt.getTime();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public Date getLoginAt() {
        return this.loginAt;
    }

    public void setLoginAt(Date loginAt) {
        this.loginAt = loginAt;
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public boolean isExpired() {
        return null != this.expiredAt;
    }

    @Override
    public Sessioninfo expireNow() {
        if (null == this.expiredAt) {
            this.expiredAt = new Date();
        }
        return this;
    }

    @Override
    public Date getExpiredAt() {
        return this.expiredAt;
    }

    public void setExpiredAt(Date expiredAt) {
        this.expiredAt = expiredAt;
    }

    @Override
    public Date getLastAccessAt() {
        return this.lastAccessAt;
    }

    public void setLastAccessAt(Date lastAccessAt) {
        this.lastAccessAt = lastAccessAt;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }
}

