/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.core.userdetail;

import java.util.Collection;
import org.beangle.commons.lang.Objects;
import org.beangle.security.core.GrantedAuthority;
import org.beangle.security.core.userdetail.UserDetail;

public class DefaultUserDetailBean
implements UserDetail {
    private static final long serialVersionUID = 1L;
    private String password;
    private String username;
    private Collection<GrantedAuthority> authorities;
    private boolean accountExpired;
    private boolean accountLocked;
    private boolean credentialsExpired;
    private boolean enabled;

    public DefaultUserDetailBean(String username, String password, Collection<? extends GrantedAuthority> authorities) {
        this(username, password, true, false, false, false, authorities);
    }

    public DefaultUserDetailBean(String username, String password, boolean enabled, boolean accountExpired, boolean credentialsExpired, boolean accountLocked, Collection<? extends GrantedAuthority> authorities) throws IllegalArgumentException {
        if (username == null || "".equals(username) || password == null) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.username = username;
        this.password = password;
        this.enabled = enabled;
        this.accountExpired = accountExpired;
        this.credentialsExpired = credentialsExpired;
        this.accountLocked = accountLocked;
        this.authorities = authorities;
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof DefaultUserDetailBean) || rhs == null) {
            return false;
        }
        DefaultUserDetailBean user = (DefaultUserDetailBean)rhs;
        return Objects.equalsBuilder().add((Object)this.getUsername(), (Object)user.getUsername()).add((Object)this.getPassword(), (Object)user.getPassword()).add(this.isAccountExpired(), user.isAccountLocked()).add(this.isAccountLocked(), user.isAccountLocked()).add(this.isCredentialsExpired(), user.isCredentialsExpired()).add(this.isEnabled(), user.isEnabled()).isEquals();
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public int hashCode() {
        return null == this.getUsername() ? 629 : this.getUsername().hashCode();
    }

    @Override
    public boolean isAccountExpired() {
        return this.accountExpired;
    }

    @Override
    public boolean isAccountLocked() {
        return this.accountLocked;
    }

    @Override
    public boolean isCredentialsExpired() {
        return this.credentialsExpired;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(": ");
        sb.append("Username: ").append(this.username).append("; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Enabled: ").append(this.enabled).append("; ");
        sb.append("AccountExpired: ").append(this.accountExpired).append("; ");
        sb.append("credentialsExpired: ").append(this.credentialsExpired).append("; ");
        sb.append("AccountLocked: ").append(this.accountLocked).append("; ");
        if (!this.getAuthorities().isEmpty()) {
            sb.append("Granted Authorities: ");
            for (GrantedAuthority authority : this.getAuthorities()) {
                sb.append(authority.toString()).append(", ");
            }
            sb.deleteCharAt(sb.length() - 1);
        } else {
            sb.append("Not granted any authorities");
        }
        return sb.toString();
    }
}

