/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.ldap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.beangle.commons.lang.Strings;
import org.beangle.security.ldap.auth.DefaultLdapValidator;
import org.beangle.security.ldap.connect.LdapUserStore;
import org.beangle.security.ldap.connect.SimpleLdapUserStore;

public class LdapMain {
    private static void println(String msg) {
        LdapMain.println(msg);
    }

    private SimpleLdapUserStore getStore(String url, String username, String password, String base) {
        return new SimpleLdapUserStore(url, username, password, base);
    }

    private void tryGet(LdapUserStore store, String name) {
        String dn = store.getUserDN(name);
        String pwd = store.getPassword(name);
        if (null == dn) {
            LdapMain.println("Cannot find :" + name);
        } else {
            LdapMain.println("Find:" + name);
            LdapMain.println("dn:" + dn);
            LdapMain.println("pwd:" + pwd);
        }
    }

    private void tryTestPassword(LdapUserStore store, String name, String password) {
        DefaultLdapValidator ldapValidator = new DefaultLdapValidator(store);
        boolean isTrue = ldapValidator.verifyPassword(name, password);
        LdapMain.println("password " + (isTrue ? " ok! " : " WRONG!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 4) {
            LdapMain.println("Usage: LdapMain host:port username password base");
            return;
        }
        String host = args[0];
        String username = args[1];
        String password = args[2];
        String base = args[3];
        LdapMain a = new LdapMain();
        LdapMain.println("Connecting to ldap://" + host);
        LdapMain.println("Using base:" + base);
        SimpleLdapUserStore store = a.getStore("ldap://" + host, username, password, base);
        LdapMain.println("Enter query user[/password]: ");
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        String value = stdin.readLine();
        while (Strings.isNotBlank((CharSequence)value)) {
            String myname = value;
            String mypass = null;
            if (value.contains("/")) {
                myname = Strings.substringBefore((String)value, (String)"/");
                mypass = Strings.substringAfter((String)value, (String)"/");
            }
            try {
                a.tryGet(store, myname);
                if (null != mypass) {
                    a.tryTestPassword(store, myname, mypass);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                LdapMain.println("Enter query user[/password]: ");
            }
            value = stdin.readLine();
        }
    }
}

