/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.ldap.auth;

import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.directory.InitialDirContext;
import org.beangle.security.auth.BadCredentialsException;
import org.beangle.security.ldap.auth.LdapValidator;
import org.beangle.security.ldap.connect.LdapUserStore;

public class SimpleBindValidator
implements LdapValidator {
    private Hashtable<String, String> properties = new Hashtable();
    private LdapUserStore userStore;

    private Hashtable<String, String> getBuildEnv(String userName, String password) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.userStore.getUrl());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", userName);
        env.put("java.naming.security.credentials", password);
        return env;
    }

    @Override
    public boolean verifyPassword(String userDN, String password) {
        Hashtable<String, String> env = this.getBuildEnv(userDN, password);
        env.putAll(this.properties);
        try {
            new InitialDirContext(env).close();
            return true;
        }
        catch (AuthenticationException ae) {
            throw new BadCredentialsException();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Hashtable<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Hashtable<String, String> properties) {
        this.properties = properties;
    }

    public LdapUserStore getUserStore() {
        return this.userStore;
    }

    public void setUserStore(LdapUserStore userStore) {
        this.userStore = userStore;
    }

    public String getUserDN(String name) {
        return this.userStore.getUserDN(name);
    }
}

