/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.ldap.connect;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.naming.CompositeName;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.beangle.commons.bean.Disposable;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.Strings;
import org.beangle.security.ldap.connect.LdapUserStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLdapUserStore
implements LdapUserStore,
Disposable {
    private Logger logger = LoggerFactory.getLogger(SimpleLdapUserStore.class);
    private String url;
    private String userName;
    private String password;
    private String base;
    private DirContext ctx;
    private String uidName = "uid";
    private Hashtable<String, String> properties = new Hashtable();

    public SimpleLdapUserStore() {
    }

    public SimpleLdapUserStore(String url, String userName, String password, String base) {
        Assert.notNull((Object)url);
        Assert.notNull((Object)userName);
        Assert.notNull((Object)password);
        Assert.notNull((Object)base);
        this.url = url;
        this.userName = userName;
        this.password = password;
        this.base = base;
    }

    @Override
    public String getUserDN(String uid) {
        DirContext ctx = this.getContext();
        if (ctx == null) {
            return null;
        }
        String result = null;
        String condition = Strings.concat((String[])new String[]{this.uidName, "=", uid});
        try {
            String[] attrList = new String[]{this.uidName};
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            constraints.setReturningAttributes(attrList);
            NamingEnumeration<SearchResult> results = ctx.search(this.base, condition, constraints);
            if (results.hasMore()) {
                SearchResult si = results.next();
                result = Strings.concat((String[])new String[]{si.getName(), ",", this.base});
            }
            results.close();
            results = null;
        }
        catch (Throwable e) {
            this.logger.error("Ldap search error,uid=" + uid, e);
        }
        return result;
    }

    @Override
    public String getPassword(String uid) {
        Set<Attribute> passwords = this.getAttributes(uid, "userPassword");
        if (passwords.isEmpty()) {
            return null;
        }
        Iterator<Attribute> i$ = passwords.iterator();
        if (i$.hasNext()) {
            byte[] encPassword;
            Attribute attr = i$.next();
            try {
                encPassword = (byte[])attr.get();
            }
            catch (NamingException e) {
                this.logger.error("get password of " + uid + "error", (Throwable)e);
                return null;
            }
            return new String(encPassword);
        }
        return null;
    }

    @Override
    public Set<Attribute> getAttributes(String uid, String attrName) {
        Set values = CollectUtils.newHashSet();
        DirContext ctx = this.getContext();
        if (ctx == null) {
            return values;
        }
        try {
            String dn = this.getUserDN(uid);
            if (dn == null) {
                this.logger.debug("User {} not found", (Object)uid);
                return values;
            }
            CompositeName userID = new CompositeName(dn);
            Attributes attrs = null;
            attrs = null != attrName ? ctx.getAttributes(userID, new String[]{attrName}) : ctx.getAttributes(userID);
            NamingEnumeration<? extends Attribute> ne = attrs.getAll();
            while (ne.hasMoreElements()) {
                Attribute attr = (Attribute)ne.nextElement();
                values.add(attr);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return values;
    }

    private Hashtable<String, String> getBuildEnv() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.url);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.userName);
        env.put("java.naming.security.credentials", this.password);
        return env;
    }

    private synchronized boolean connect() {
        Hashtable<String, String> env = this.getBuildEnv();
        env.putAll(this.properties);
        try {
            this.ctx = new InitialDirContext(env);
            this.logger.debug("Ldap server connect success.");
            return true;
        }
        catch (Exception e) {
            this.logger.error("Ldap server connect failure", (Throwable)e);
            return false;
        }
    }

    public synchronized void disConnect() {
        if (this.ctx != null) {
            try {
                this.ctx.close();
                this.ctx = null;
                this.logger.debug("Ldap connect closed.");
            }
            catch (NamingException e) {
                this.logger.error("Failure to close ldap connection.", (Throwable)e);
            }
        }
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public Hashtable<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Hashtable<String, String> properties) {
        this.properties = properties;
    }

    private DirContext getContext() {
        if (null == this.ctx) {
            this.connect();
        }
        return this.ctx;
    }

    public void destroy() {
        this.disConnect();
    }

    public void setUidName(String uidName) {
        this.uidName = uidName;
    }
}

