/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.access.intercept;

import org.beangle.commons.bean.Initializing;
import org.beangle.commons.lang.Assert;
import org.beangle.security.access.AccessDeniedException;
import org.beangle.security.access.AuthorityManager;
import org.beangle.security.access.intercept.InterceptorStatusToken;
import org.beangle.security.auth.AuthenticationManager;
import org.beangle.security.core.Authentication;
import org.beangle.security.core.AuthenticationException;
import org.beangle.security.core.context.SecurityContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSecurityInterceptor
implements Initializing {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractSecurityInterceptor.class);
    private AuthorityManager authorityManager;
    private AuthenticationManager authenticationManager;
    private boolean alwaysReauthenticate = false;
    private boolean rejectPublicInvocations = false;
    private boolean validateConfigAttributes = true;

    protected Object afterInvocation(InterceptorStatusToken token, Object returnedObject) {
        if (token == null) {
            return returnedObject;
        }
        if (token.isContextHolderRefreshRequired()) {
            logger.debug("Reverting to original Authentication: {}", (Object)token.getAuthentication());
            SecurityContextHolder.getContext().setAuthentication(token.getAuthentication());
        }
        return returnedObject;
    }

    public void init() throws Exception {
        Assert.notNull(this.getSecureObjectClass(), (String)"Subclass must provide a non-null response to getSecureObjectClass()", (Object[])new Object[0]);
        Assert.notNull((Object)this.authenticationManager, (String)"An AuthenticationManager is required", (Object[])new Object[0]);
        Assert.notNull((Object)this.authorityManager, (String)"An AuthorityManager is required", (Object[])new Object[0]);
    }

    protected InterceptorStatusToken beforeInvocation(Object object) {
        Assert.notNull((Object)object, (String)"Object was null", (Object[])new Object[0]);
        if (!this.getSecureObjectClass().isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("Security invocation attempted for object " + object.getClass().getName() + " but AbstractSecurityInterceptor only configured to support secure objects of type: " + this.getSecureObjectClass());
        }
        Authentication authenticated = this.authenticateIfRequired();
        if (!this.authorityManager.isAuthorized(authenticated, object)) {
            throw new AccessDeniedException(object, "access denied");
        }
        logger.debug("Authorization successful");
        return new InterceptorStatusToken(authenticated, false, object);
    }

    private Authentication authenticateIfRequired() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (null == authentication) {
            throw new AuthenticationException();
        }
        if (authentication.isAuthenticated() && !this.alwaysReauthenticate) {
            logger.debug("Previously Authenticated: {}", (Object)authentication);
            return authentication;
        }
        authentication = this.authenticationManager.authenticate(authentication);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        return authentication;
    }

    public AuthorityManager getAuthorityManager() {
        return this.authorityManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public abstract Class<?> getSecureObjectClass();

    public boolean isAlwaysReauthenticate() {
        return this.alwaysReauthenticate;
    }

    public boolean isRejectPublicInvocations() {
        return this.rejectPublicInvocations;
    }

    public boolean isValidateConfigAttributes() {
        return this.validateConfigAttributes;
    }

    public void setAuthorityManager(AuthorityManager authorityManager) {
        this.authorityManager = authorityManager;
    }

    public void setAlwaysReauthenticate(boolean alwaysReauthenticate) {
        this.alwaysReauthenticate = alwaysReauthenticate;
    }

    public void setAuthenticationManager(AuthenticationManager newManager) {
        this.authenticationManager = newManager;
    }

    public void setRejectPublicInvocations(boolean rejectPublicInvocations) {
        this.rejectPublicInvocations = rejectPublicInvocations;
    }

    public void setValidateConfigAttributes(boolean validateConfigAttributes) {
        this.validateConfigAttributes = validateConfigAttributes;
    }
}

