/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.auth.dao;

import org.beangle.commons.lang.Strings;
import org.beangle.security.auth.AccountExpiredException;
import org.beangle.security.auth.AuthenticationProvider;
import org.beangle.security.auth.CredentialsExpiredException;
import org.beangle.security.auth.DisabledException;
import org.beangle.security.auth.LockedException;
import org.beangle.security.auth.UsernamePasswordAuthentication;
import org.beangle.security.core.Authentication;
import org.beangle.security.core.AuthenticationException;
import org.beangle.security.core.userdetail.UserDetail;
import org.beangle.security.core.userdetail.UserDetailChecker;
import org.beangle.security.core.userdetail.UsernameNotFoundException;

public abstract class AbstractUserDetailAuthenticationProvider
implements AuthenticationProvider {
    private boolean forcePrincipalAsString = false;
    private UserDetailChecker preAuthenticationChecker = new DefaultPreAuthenticationChecker();
    private UserDetailChecker postAuthenticationChecker = new DefaultPostAuthenticationChecker();

    protected abstract void additionalAuthenticationChecks(UserDetail var1, Authentication var2) throws AuthenticationException;

    protected String determinePrincipal(Authentication authentication) {
        return authentication.getPrincipal() == null ? "NONE_PROVIDED" : authentication.getName();
    }

    @Override
    public Authentication authenticate(Authentication auth) throws AuthenticationException {
        String username = this.determinePrincipal(auth);
        if (Strings.isEmpty((CharSequence)username)) {
            AuthenticationException ex = new AuthenticationException("cannot find username for " + auth.getPrincipal());
            ex.setAuthentication(auth);
            throw ex;
        }
        UserDetail user = this.retrieveUser(username, auth);
        if (null == user) {
            throw new UsernameNotFoundException();
        }
        this.preAuthenticationChecker.check(user);
        this.additionalAuthenticationChecks(user, auth);
        this.postAuthenticationChecker.check(user);
        Object principalToReturn = user;
        if (this.forcePrincipalAsString) {
            principalToReturn = user.getUsername();
        }
        return this.createSuccessAuthentication(principalToReturn, auth, user);
    }

    protected Authentication createSuccessAuthentication(Object principal, Authentication authentication, UserDetail user) {
        UsernamePasswordAuthentication result = new UsernamePasswordAuthentication(principal, authentication.getCredentials(), user.getAuthorities());
        result.setDetails(authentication.getDetails());
        return result;
    }

    protected void doAfterPropertiesSet() throws Exception {
    }

    public boolean isForcePrincipalAsString() {
        return this.forcePrincipalAsString;
    }

    protected abstract UserDetail retrieveUser(String var1, Authentication var2) throws AuthenticationException;

    public void setForcePrincipalAsString(boolean forcePrincipalAsString) {
        this.forcePrincipalAsString = forcePrincipalAsString;
    }

    @Override
    public boolean supports(Class<? extends Authentication> authentication) {
        return UsernamePasswordAuthentication.class.isAssignableFrom(authentication);
    }

    protected UserDetailChecker getPreAuthenticationChecks() {
        return this.preAuthenticationChecker;
    }

    public void setPreAuthenticationChecks(UserDetailChecker preAuthenticationChecks) {
        this.preAuthenticationChecker = preAuthenticationChecks;
    }

    protected UserDetailChecker getPostAuthenticationChecks() {
        return this.postAuthenticationChecker;
    }

    public void setPostAuthenticationChecks(UserDetailChecker postAuthenticationChecks) {
        this.postAuthenticationChecker = postAuthenticationChecks;
    }

    private class DefaultPostAuthenticationChecker
    implements UserDetailChecker {
        private DefaultPostAuthenticationChecker() {
        }

        @Override
        public void check(UserDetail user) {
            if (user.isCredentialsExpired()) {
                throw new CredentialsExpiredException(null, user);
            }
        }
    }

    private class DefaultPreAuthenticationChecker
    implements UserDetailChecker {
        private DefaultPreAuthenticationChecker() {
        }

        @Override
        public void check(UserDetail user) {
            if (user.isAccountLocked()) {
                throw new LockedException(null, user);
            }
            if (!user.isEnabled()) {
                throw new DisabledException(null, user);
            }
            if (user.isAccountExpired()) {
                throw new AccountExpiredException(null, user);
            }
        }
    }
}

