/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.core.authority;

import java.io.Serializable;
import java.util.List;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Assert;
import org.beangle.security.core.GrantedAuthority;

public class GrantedAuthorityBean
implements GrantedAuthority,
Serializable {
    private static final long serialVersionUID = 1L;
    private Object role;

    public GrantedAuthorityBean(Object role) {
        Assert.notNull((Object)role, (String)"A granted authority textual representation is required", (Object[])new Object[0]);
        this.role = role;
    }

    public static List<GrantedAuthority> build(Object ... roles) {
        List authorities = CollectUtils.newArrayList((int)roles.length);
        for (Object role : roles) {
            authorities.add(new GrantedAuthorityBean(role));
        }
        return authorities;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GrantedAuthority) {
            GrantedAuthority attr = (GrantedAuthority)obj;
            return this.role.equals(attr.getAuthority());
        }
        return false;
    }

    @Override
    public Object getAuthority() {
        return this.role;
    }

    public int hashCode() {
        return this.role.hashCode();
    }

    public String toString() {
        return this.role.toString();
    }

    @Override
    public int compareTo(GrantedAuthority o) {
        if (o != null) {
            Object rhsRole = o.getAuthority();
            if (rhsRole == null) {
                return -1;
            }
            if (this.role instanceof Comparable) {
                return ((Comparable)this.role).compareTo(rhsRole);
            }
            throw new RuntimeException("Cannot compare GrantedAuthorityBean using role:" + this.role);
        }
        return -1;
    }
}

