/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.core.context;

import org.beangle.commons.lang.Assert;
import org.beangle.security.core.context.SecurityContext;
import org.beangle.security.core.context.SecurityContextBean;
import org.beangle.security.core.context.SecurityContextHolderStrategy;

public class ThreadLocalHolderStrategy
implements SecurityContextHolderStrategy {
    private static ThreadLocal<SecurityContext> contextHolder = new ThreadLocal();

    @Override
    public void clearContext() {
        contextHolder.set(null);
    }

    @Override
    public SecurityContext getContext() {
        if (contextHolder.get() == null) {
            contextHolder.set(new SecurityContextBean());
        }
        return contextHolder.get();
    }

    @Override
    public void setContext(SecurityContext context) {
        Assert.notNull((Object)context, (String)"Only non-null SecurityContext instances are permitted", (Object[])new Object[0]);
        contextHolder.set(context);
    }
}

