/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.ldap.auth;

import java.security.NoSuchAlgorithmException;
import org.beangle.security.ldap.auth.LdapPasswordHandler;
import org.beangle.security.ldap.auth.LdapValidator;
import org.beangle.security.ldap.connect.LdapUserStore;

public class DefaultLdapValidator
implements LdapValidator {
    private LdapUserStore userStore;

    public DefaultLdapValidator() {
    }

    public DefaultLdapValidator(LdapUserStore userStore) {
        this.userStore = userStore;
    }

    @Override
    public boolean verifyPassword(String name, String password) {
        String ldapPwd = this.userStore.getPassword(name);
        try {
            return null != ldapPwd && LdapPasswordHandler.getInstance().verify(ldapPwd, password);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void setUserStore(LdapUserStore userStore) {
        this.userStore = userStore;
    }
}

