/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.core.context;

import org.beangle.commons.security.Request;
import org.beangle.security.core.session.Session;

public class SecurityContext {
    private static ThreadLocal<SecurityContext> holder = new ThreadLocal();
    private final Session session;
    private final Request request;
    private final boolean root;
    private final String runAs;

    public SecurityContext(Session session, Request request, boolean root, String runAs) {
        this.session = session;
        this.request = request;
        this.root = root;
        this.runAs = runAs;
    }

    public static void clear() {
        holder.set(null);
    }

    public static void set(SecurityContext context) {
        holder.set(context);
    }

    public static SecurityContext get() {
        return holder.get();
    }

    public static ThreadLocal<SecurityContext> getHolder() {
        return holder;
    }

    public static void setHolder(ThreadLocal<SecurityContext> holder) {
        SecurityContext.holder = holder;
    }

    public Session getSession() {
        return this.session;
    }

    public Request getRequest() {
        return this.request;
    }

    public String getUser() {
        if (this.root && null != this.runAs) {
            return this.runAs;
        }
        if (null == this.session) {
            return "anonymous";
        }
        return this.session.getPrincipal().getName();
    }

    public boolean isRoot() {
        return this.root;
    }

    public String getRunAs() {
        return this.runAs;
    }
}

