/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.core.userdetail;

import org.beangle.commons.text.i18n.TextResource;
import org.beangle.commons.text.i18n.impl.NullTextResource;
import org.beangle.security.authc.AccountExpiredException;
import org.beangle.security.authc.CredentialsExpiredException;
import org.beangle.security.authc.DisabledException;
import org.beangle.security.authc.LockedException;
import org.beangle.security.core.userdetail.Account;
import org.beangle.security.core.userdetail.UserDetailChecker;

public class AccountStatusChecker
implements UserDetailChecker {
    protected TextResource textResource = new NullTextResource();

    @Override
    public void check(Account user) {
        if (user.isAccountLocked()) {
            throw new LockedException(this.textResource.getText("AbstractUserDetailsAuthenticationProvider.locked", "User account is locked", new Object[0]), user);
        }
        if (!user.isEnabled()) {
            throw new DisabledException(this.textResource.getText("AbstractUserDetailsAuthenticationProvider.disabled", "User is disabled", new Object[0]), user);
        }
        if (user.isAccountExpired()) {
            throw new AccountExpiredException(this.textResource.getText("AbstractUserDetailsAuthenticationProvider.expired", "User account has expired", new Object[0]), user);
        }
        if (user.isCredentialExpired()) {
            throw new CredentialsExpiredException(this.textResource.getText("AbstractUserDetailsAuthenticationProvider.credentialsExpired", "User credentials have expired", new Object[0]), user);
        }
    }

    public void setTextResource(TextResource textResource) {
        this.textResource = textResource;
    }
}

