/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.core.userdetail;

import java.util.Map;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Objects;
import org.beangle.security.core.userdetail.Account;

public class DefaultAccount
implements Account {
    private static int Locked = 1;
    private static int Disabled = 2;
    private static int AccountExpired = 4;
    private static int CredentialExpired = 8;
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private String remoteToken;
    private String authorities;
    private String permissions;
    private Map<String, Object> details = CollectUtils.newHashMap();
    private int status;

    private void change(boolean value, int mask) {
        if (value) {
            this.status |= mask;
        } else if ((this.status & mask) > 0) {
            this.status ^= mask;
        }
    }

    private boolean get(int mask) {
        return (this.status & mask) > 0;
    }

    public DefaultAccount(String username, String description, Map<String, Object> details) {
        this(username, description);
        this.details = details;
    }

    public DefaultAccount(String name, String description) throws IllegalArgumentException {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.name = name;
        this.description = description;
        this.setAccountExpired(false);
        this.setAccountLocked(false);
        this.setEnabled(true);
        this.setCredentialExpired(false);
    }

    @Override
    public boolean equals(Object rhs) {
        if (!(rhs instanceof DefaultAccount) || rhs == null) {
            return false;
        }
        DefaultAccount user = (DefaultAccount)rhs;
        return Objects.equalsBuilder().add((Object)this.getName(), (Object)user.getName()).add((Object)this.getDescription(), (Object)user.getDescription()).add(this.isAccountExpired(), user.isAccountLocked()).add(this.isAccountLocked(), user.isAccountLocked()).add(this.isCredentialExpired(), user.isCredentialExpired()).add(this.isEnabled(), user.isEnabled()).isEquals();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getRemoteToken() {
        return this.remoteToken;
    }

    public void setRemoteToken(String remoteToken) {
        this.remoteToken = remoteToken;
    }

    @Override
    public Map<String, Object> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, Object> details) {
        this.details = details;
    }

    @Override
    public boolean isCredentialExpired() {
        return this.get(CredentialExpired);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setCredentialExpired(boolean credentialExpired) {
        this.change(credentialExpired, CredentialExpired);
    }

    public void setAccountExpired(boolean accountExpired) {
        this.change(accountExpired, AccountExpired);
    }

    public void setAccountLocked(boolean accountLocked) {
        this.change(accountLocked, Locked);
    }

    public void setEnabled(boolean enabled) {
        this.change(enabled, Disabled);
    }

    @Override
    public int hashCode() {
        return null == this.getName() ? 629 : this.getName().hashCode();
    }

    @Override
    public boolean isAccountExpired() {
        return this.get(AccountExpired);
    }

    @Override
    public boolean isAccountLocked() {
        return this.get(Locked);
    }

    @Override
    public boolean isEnabled() {
        return this.get(Disabled);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(": ");
        sb.append("name: ").append(this.name).append("; ");
        sb.append("status: ").append(this.status).append("; ");
        if (!this.getDetails().isEmpty()) {
            sb.append("Details: ");
            for (Map.Entry<String, Object> d : this.getDetails().entrySet()) {
                sb.append(d.getKey()).append('=').append(d.getValue());
            }
            sb.deleteCharAt(sb.length() - 1);
        } else {
            sb.append("Not granted any authorities");
        }
        return sb.toString();
    }

    public String getAuthorities() {
        return this.authorities;
    }

    public void setAuthorities(String authorities) {
        this.authorities = authorities;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }
}

