/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.Strings;

public interface Profile
extends Serializable {
    public static final String AllValue = "*";

    public Map<String, Object> getProperties();

    default public Object getProperty(String name) {
        return this.getProperties().get(name);
    }

    default public boolean matches(Profile other) {
        boolean matched = true;
        if (!other.getProperties().isEmpty()) {
            for (Map.Entry<String, Object> property : other.getProperties().entrySet()) {
                Object target = property.getValue();
                Object source = this.getProperty(property.getKey());
                if (null == source) {
                    matched = false;
                    break;
                }
                matched = AllValue.equals(source);
                if (matched) continue;
                if (!target.equals(AllValue)) {
                    if (target instanceof Collection) {
                        if (source instanceof Collection) {
                            matched = ((Collection)source).containsAll((Collection)target);
                        }
                    } else {
                        Set targetValues = CollectUtils.newHashSet((Object[])Strings.split((String)target.toString(), (String)","));
                        Set sourceValues = CollectUtils.newHashSet((Object[])Strings.split((String)source.toString(), (String)","));
                        matched = sourceValues.containsAll(targetValues);
                    }
                }
                if (matched) continue;
                break;
            }
        }
        return matched;
    }
}

