/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.authc;

import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.commons.text.i18n.NullTextResource;
import org.beangle.commons.text.i18n.TextResource;
import org.beangle.security.authc.Account;
import org.beangle.security.authc.AccountExpiredException;
import org.beangle.security.authc.AuthenticationException;
import org.beangle.security.authc.AuthenticationException$;
import org.beangle.security.authc.AuthenticationInfo;
import org.beangle.security.authc.AuthenticationToken;
import org.beangle.security.authc.CredentialsExpiredException;
import org.beangle.security.authc.DisabledException;
import org.beangle.security.authc.LockedException;
import org.beangle.security.authc.Mergable;
import org.beangle.security.authc.UsernameNotFoundException;
import org.beangle.security.authc.UsernameNotFoundException$;
import org.beangle.security.authc.UsernamePasswordAuthenticationToken;
import org.beangle.security.realm.Realm;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]4Q!\u0001\u0002\u0002\u0002-\u0011A#\u00112tiJ\f7\r^!dG>,h\u000e\u001e*fC2l'BA\u0002\u0005\u0003\u0015\tW\u000f\u001e5d\u0015\t)a!\u0001\u0005tK\u000e,(/\u001b;z\u0015\t9\u0001\"A\u0004cK\u0006tw\r\\3\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0007\u00131A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u000bI,\u0017\r\\7\n\u0005]!\"!\u0002*fC2l\u0007CA\r\u001f\u001b\u0005Q\"BA\u000e\u001d\u0003\u001dawnZ4j]\u001eT!!\b\u0004\u0002\u000f\r|W.\\8og&\u0011qD\u0007\u0002\b\u0019><w-\u001b8h\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t!\u0001C\u0005'\u0001\u0001\u0007\t\u0019!C\u0001O\u00051\u0001/\u0019:f]R,\u0012a\t\u0005\nS\u0001\u0001\r\u00111A\u0005\u0002)\n!\u0002]1sK:$x\fJ3r)\tYc\u0006\u0005\u0002\u000eY%\u0011QF\u0004\u0002\u0005+:LG\u000fC\u00040Q\u0005\u0005\t\u0019A\u0012\u0002\u0007a$\u0013\u0007\u0003\u00042\u0001\u0001\u0006KaI\u0001\ba\u0006\u0014XM\u001c;!\u0011\u001d\u0019\u0004\u00011A\u0005\u0002Q\n!\u0001\u001e:\u0016\u0003U\u0002\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\t%\f\u0004H\u001c\u0006\u0003uq\tA\u0001^3yi&\u0011Ah\u000e\u0002\r)\u0016DHOU3t_V\u00148-\u001a\u0005\b}\u0001\u0001\r\u0011\"\u0001@\u0003\u0019!(o\u0018\u0013fcR\u00111\u0006\u0011\u0005\b_u\n\t\u00111\u00016\u0011\u0019\u0011\u0005\u0001)Q\u0005k\u0005\u0019AO\u001d\u0011\t\u000b\u0011\u0003A\u0011C#\u0002%\u0011,G/\u001a:nS:,\u0007K]5oG&\u0004\u0018\r\u001c\u000b\u0003\r6\u0003\"a\u0012&\u000f\u00055A\u0015BA%\u000f\u0003\u0019\u0001&/\u001a3fM&\u00111\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%s\u0001\"\u0002(D\u0001\u0004y\u0015!\u0002;pW\u0016t\u0007C\u0001\u0013Q\u0013\t\t&AA\nBkRDWM\u001c;jG\u0006$\u0018n\u001c8U_.,g\u000eC\u0003T\u0001\u0011\u0005C+A\u000bhKR\fU\u000f\u001e5f]RL7-\u0019;j_:LeNZ8\u0015\u0005UC\u0006C\u0001\u0013W\u0013\t9&AA\u0004BG\u000e|WO\u001c;\t\u000b9\u0013\u0006\u0019A(\t\u000bi\u0003A\u0011C.\u0002\u001f\u0005$G-\u001b;j_:\fGn\u00115fG.$2a\u000b/^\u0011\u0015q\u0015\f1\u0001P\u0011\u0015q\u0016\f1\u0001V\u0003\t\t7\rC\u0003a\u0001\u0019E\u0011-A\u0006m_\u0006$\u0017iY2pk:$HC\u00012f!\ri1-V\u0005\u0003I:\u0011aa\u00149uS>t\u0007\"\u00024`\u0001\u00049\u0017!\u00039sS:\u001c\u0017\u000e]1m!\ti\u0001.\u0003\u0002j\u001d\t\u0019\u0011I\\=\t\u000b-\u0004a\u0011\u00037\u0002!\r\u0014X\rZ3oi&\fGn]\"iK\u000e\\GcA\u0016n]\")aJ\u001ba\u0001\u001f\")qN\u001ba\u0001+\u00069\u0011mY2pk:$\b\"B9\u0001\t\u0003\u0011\u0018\u0001C:vaB|'\u000f^:\u0015\u0005M4\bCA\u0007u\u0013\t)hBA\u0004C_>dW-\u00198\t\u000b9\u0003\b\u0019A(")
public abstract class AbstractAccountRealm
implements Realm,
Logging {
    private AbstractAccountRealm parent;
    private TextResource tr;
    private final Logger org$beangle$commons$logging$Logging$$logger;

    public Logger org$beangle$commons$logging$Logging$$logger() {
        return this.org$beangle$commons$logging$Logging$$logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$org$beangle$commons$logging$Logging$$logger_$eq(Logger x$1) {
        this.org$beangle$commons$logging$Logging$$logger = x$1;
    }

    public final boolean debugEnabled() {
        return Logging.class.debugEnabled((Logging)this);
    }

    public final void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public final void trace(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public final void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public final void debug(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public final void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public final void info(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public final void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public final void warn(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public final void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public final void error(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public AbstractAccountRealm parent() {
        return this.parent;
    }

    public void parent_$eq(AbstractAccountRealm x$1) {
        this.parent = x$1;
    }

    public TextResource tr() {
        return this.tr;
    }

    public void tr_$eq(TextResource x$1) {
        this.tr = x$1;
    }

    public String determinePrincipal(AuthenticationToken token) {
        return token == null ? "NONE_PROVIDED" : token.getName();
    }

    @Override
    public Account getAuthenticationInfo(AuthenticationToken token) {
        Option<Account> option;
        block8: {
            block9: {
                Account merged;
                block7: {
                    block6: {
                        Mergable mergable;
                        merged = this.parent() == null ? null : this.parent().getAuthenticationInfo(token);
                        String principal = this.determinePrincipal(token);
                        Strings$ strings$ = Strings$.MODULE$;
                        if (principal == null || 0 == principal.length()) {
                            throw new AuthenticationException(new StringBuilder().append((Object)"cannot find username for ").append(token.principal()).toString(), token, AuthenticationException$.MODULE$.$lessinit$greater$default$3());
                        }
                        option = this.loadAccount(principal);
                        if (!(option instanceof Some)) break block6;
                        Some some = (Some)option;
                        if (merged == null) {
                            merged = (Account)some.x();
                            this.credentialsCheck(token, (Account)some.x());
                            mergable = BoxedUnit.UNIT;
                        } else {
                            mergable = merged.merge((AuthenticationInfo)some.x());
                        }
                        this.additionalCheck(token, merged);
                        break block7;
                    }
                    if (!None$.MODULE$.equals(option)) break block8;
                    if (merged != null) break block9;
                }
                return merged;
            }
            throw new UsernameNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find account data for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{token})), null, UsernameNotFoundException$.MODULE$.$lessinit$greater$default$3());
        }
        throw new MatchError(option);
    }

    public void additionalCheck(AuthenticationToken token, Account ac) {
        if (ac.accountLocked()) {
            throw new LockedException(this.tr().apply("AccountStatusChecker.locked", "User account is locked", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0])), token);
        }
        if (ac.disabled()) {
            throw new DisabledException(this.tr().apply("AccountStatusChecker.disabled", "User is disabled", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0])), token);
        }
        if (ac.accountExpired()) {
            throw new AccountExpiredException(this.tr().apply("AccountStatusChecker.expired", "User account has expired", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0])), token);
        }
        if (ac.credentialExpired()) {
            throw new CredentialsExpiredException(this.tr().apply("AccountStatusChecker.credentialExpired", "User credentials have expired", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0])), token);
        }
    }

    public abstract Option<Account> loadAccount(Object var1);

    public abstract void credentialsCheck(AuthenticationToken var1, Account var2);

    @Override
    public boolean supports(AuthenticationToken token) {
        return token instanceof UsernamePasswordAuthenticationToken;
    }

    public AbstractAccountRealm() {
        Logging.class.$init$((Logging)this);
        this.tr = new NullTextResource();
    }
}

