/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.context;

import java.lang.reflect.Constructor;
import org.beangle.commons.lang.Throwables$;
import org.beangle.security.authc.AuthenticationInfo;
import org.beangle.security.context.ContextHolder;
import org.beangle.security.context.GlobalHolder$;
import org.beangle.security.context.ThreadLocalHolder;
import org.beangle.security.session.Session;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;

public final class SecurityContext$ {
    public static final SecurityContext$ MODULE$;
    private final String Anonymous;
    private final ContextHolder holder;

    static {
        new SecurityContext$();
    }

    public String Anonymous() {
        return this.Anonymous;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ContextHolder buildHolder(String strategyName) {
        if ("threadLocal".equals(strategyName)) {
            return new ThreadLocalHolder(false);
        }
        if ("inheritableThreadLocal".equals(strategyName)) {
            return new ThreadLocalHolder(true);
        }
        if ("global".equals(strategyName)) {
            return GlobalHolder$.MODULE$;
        }
        try {
            Class<?> clazz = Class.forName(strategyName);
            Constructor<?> customStrategy = clazz.getConstructor(new Class[0]);
            return (ContextHolder)customStrategy.newInstance(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing()));
        }
        catch (Exception exception) {
            throw Throwables$.MODULE$.propagate((Throwable)exception);
        }
    }

    private ContextHolder holder() {
        return this.holder;
    }

    public void session_$eq(Session session) {
        this.holder().session_$eq(session);
    }

    public Option<Session> getSession() {
        return this.holder().session() == null ? None$.MODULE$ : new Some((Object)this.holder().session());
    }

    public Session session() {
        if (this.holder().session() == null) {
            throw new SecurityException("Not Login");
        }
        return this.holder().session();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasValidContext() {
        Option<Session> sess = this.getSession();
        if (sess.isEmpty()) return false;
        String string = this.Anonymous();
        AuthenticationInfo authenticationInfo = ((Session)sess.get()).principal();
        if (string != null) {
            if (!string.equals(authenticationInfo)) return true;
            return false;
        }
        if (authenticationInfo == null) return false;
        return true;
    }

    public Object principal() {
        Option<Session> option;
        block4: {
            Object object;
            block3: {
                block2: {
                    option = this.getSession();
                    if (!None$.MODULE$.equals(option)) break block2;
                    object = this.Anonymous();
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                object = ((Session)some.x()).principal();
            }
            return object;
        }
        throw new MatchError(option);
    }

    private SecurityContext$() {
        MODULE$ = this;
        this.Anonymous = "anonymous";
        this.holder = this.buildHolder(System.getProperty("beangle.security.holder", "threadLocal"));
    }
}

