/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.realm.ldap;

import org.beangle.security.authc.AbstractAccountRealm;
import org.beangle.security.authc.Account;
import org.beangle.security.authc.AuthenticationToken;
import org.beangle.security.authc.BadCredentialsException;
import org.beangle.security.realm.ldap.LdapPasswordValidator;
import org.beangle.security.realm.ldap.LdapUserStore;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%3A!\u0001\u0002\u0001\u001b\t\u0001B)\u001a4bk2$H\nZ1q%\u0016\fG.\u001c\u0006\u0003\u0007\u0011\tA\u0001\u001c3ba*\u0011QAB\u0001\u0006e\u0016\fG.\u001c\u0006\u0003\u000f!\t\u0001b]3dkJLG/\u001f\u0006\u0003\u0013)\tqAY3b]\u001edWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001C\u0003\u0002\u0012\r\u0005)\u0011-\u001e;iG&\u00111\u0003\u0005\u0002\u0015\u0003\n\u001cHO]1di\u0006\u001b7m\\;oiJ+\u0017\r\\7\t\u0011U\u0001!Q1A\u0005\u0002Y\t\u0011\"^:feN#xN]3\u0016\u0003]\u0001\"\u0001G\r\u000e\u0003\tI!A\u0007\u0002\u0003\u001b1#\u0017\r]+tKJ\u001cFo\u001c:f\u0011!a\u0002A!A!\u0002\u00139\u0012AC;tKJ\u001cFo\u001c:fA!Aa\u0004\u0001BC\u0002\u0013\u0005q$A\tqCN\u001cxo\u001c:e-\u0006d\u0017\u000eZ1u_J,\u0012\u0001\t\t\u00031\u0005J!A\t\u0002\u0003+1#\u0017\r\u001d)bgN<xN\u001d3WC2LG-\u0019;pe\"AA\u0005\u0001B\u0001B\u0003%\u0001%\u0001\nqCN\u001cxo\u001c:e-\u0006d\u0017\u000eZ1u_J\u0004\u0003\"\u0002\u0014\u0001\t\u00039\u0013A\u0002\u001fj]&$h\bF\u0002)S)\u0002\"\u0001\u0007\u0001\t\u000bU)\u0003\u0019A\f\t\u000by)\u0003\u0019\u0001\u0011\t\u000b1\u0002A\u0011K\u0017\u0002!\r\u0014X\rZ3oi&\fGn]\"iK\u000e\\Gc\u0001\u00185sA\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t!QK\\5u\u0011\u0015)4\u00061\u00017\u0003\u0015!xn[3o!\tyq'\u0003\u00029!\t\u0019\u0012)\u001e;iK:$\u0018nY1uS>tGk\\6f]\")!h\u000ba\u0001w\u00059\u0011mY2pk:$\bCA\b=\u0013\ti\u0004CA\u0004BG\u000e|WO\u001c;\t\u000b}\u0002A\u0011\u000b!\u0002\u00171|\u0017\rZ!dG>,h\u000e\u001e\u000b\u0003\u0003\u0012\u00032a\f\"<\u0013\t\u0019\u0005G\u0001\u0004PaRLwN\u001c\u0005\u0006\u000bz\u0002\rAR\u0001\naJLgnY5qC2\u0004\"aL$\n\u0005!\u0003$aA!os\u0002")
public class DefaultLdapRealm
extends AbstractAccountRealm {
    private final LdapUserStore userStore;
    private final LdapPasswordValidator passwordValidator;

    public LdapUserStore userStore() {
        return this.userStore;
    }

    public LdapPasswordValidator passwordValidator() {
        return this.passwordValidator;
    }

    @Override
    public void credentialsCheck(AuthenticationToken token, Account account) {
        if (this.passwordValidator().verify(account.getName(), token.credentials().toString())) {
            return;
        }
        throw new BadCredentialsException("Incorrect password", token, null);
    }

    @Override
    public Option<Account> loadAccount(Object principal) {
        return this.userStore().load(principal);
    }

    public DefaultLdapRealm(LdapUserStore userStore, LdapPasswordValidator passwordValidator) {
        this.userStore = userStore;
        this.passwordValidator = passwordValidator;
    }
}

