/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.realm.ldap;

import java.security.MessageDigest;
import org.beangle.commons.codec.binary.Base64$;
import org.beangle.commons.codec.binary.Hex$;
import org.beangle.commons.lang.Arrays$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public final class LdapPasswordHandler$ {
    public static final LdapPasswordHandler$ MODULE$;

    static {
        new LdapPasswordHandler$();
    }

    public boolean verify(String digest, String password) {
        block6: {
            int size;
            String alg;
            String digestContent;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            if (!digest.regionMatches(true, 0, "{SHA}", 0, 5)) break block2;
                            digestContent = digest.substring(5);
                            alg = "SHA-1";
                            size = 20;
                            break block3;
                        }
                        if (!digest.regionMatches(true, 0, "{SSHA}", 0, 6)) break block4;
                        digestContent = digest.substring(6);
                        alg = "SHA-1";
                        size = 20;
                        break block3;
                    }
                    if (!digest.regionMatches(true, 0, "{MD5}", 0, 5)) break block5;
                    digestContent = digest.substring(5);
                    alg = "MD5";
                    size = 16;
                    break block3;
                }
                if (!digest.regionMatches(true, 0, "{SMD5}", 0, 6)) break block6;
                digestContent = digest.substring(6);
                alg = "MD5";
                size = 16;
            }
            MessageDigest msgDigest = MessageDigest.getInstance(alg);
            Tuple2<byte[], byte[]> hs = this.split(Base64$.MODULE$.decode(digestContent.toCharArray()), size);
            msgDigest.reset();
            msgDigest.update(password.getBytes());
            msgDigest.update((byte[])hs._2());
            return MessageDigest.isEqual((byte[])hs._1(), msgDigest.digest());
        }
        return digest.equals(password);
    }

    public String generateDigest(String password, String saltHex, String algorithm) {
        String alg = algorithm;
        if (algorithm.equalsIgnoreCase("sha")) {
            alg = "SHA-1";
        } else if (algorithm.equalsIgnoreCase("md5")) {
            alg = "MD5";
        }
        MessageDigest msgDigest = MessageDigest.getInstance(alg);
        byte[] salt = saltHex == null ? new byte[]{} : Hex$.MODULE$.decode(saltHex);
        String label = null;
        if (algorithm.startsWith("SHA")) {
            label = salt.length <= 0 ? "{SHA}" : "{SSHA}";
        } else if (algorithm.startsWith("MD5")) {
            label = salt.length <= 0 ? "{MD5}" : "{SMD5}";
        }
        msgDigest.reset();
        msgDigest.update(password.getBytes());
        msgDigest.update(salt);
        byte[] pwhash = msgDigest.digest();
        StringBuilder digest = new StringBuilder(label == null ? "" : label);
        digest.append(Base64$.MODULE$.encode((byte[])Arrays$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{pwhash, salt}), ClassTag$.MODULE$.Byte())));
        return digest.toString();
    }

    private Tuple2<byte[], byte[]> split(byte[] src, int n) {
        byte[] r;
        byte[] l;
        if (src.length <= n) {
            l = src;
            r = new byte[]{};
        } else {
            l = new byte[n];
            r = new byte[src.length - n];
            System.arraycopy(src, 0, l, 0, n);
            System.arraycopy(src, n, r, 0, r.length);
        }
        return new Tuple2((Object)l, (Object)r);
    }

    private LdapPasswordHandler$() {
        MODULE$ = this;
    }
}

