/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.security.realm.ldap;

import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.beangle.commons.bean.Disposable;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.logging.Logging;
import org.beangle.security.authc.Account;
import org.beangle.security.authc.DefaultAccount;
import org.beangle.security.realm.ldap.LdapUserStore;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u00015\u00111cU5na2,G\nZ1q+N,'o\u0015;pe\u0016T!a\u0001\u0003\u0002\t1$\u0017\r\u001d\u0006\u0003\u000b\u0019\tQA]3bY6T!a\u0002\u0005\u0002\u0011M,7-\u001e:jifT!!\u0003\u0006\u0002\u000f\t,\u0017M\\4mK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001\u001dQA\u0002\u0005\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011AA\u0005\u0003/\t\u0011Q\u0002\u00143baV\u001bXM]*u_J,\u0007CA\r\u001f\u001b\u0005Q\"BA\u000e\u001d\u0003\u0011\u0011W-\u00198\u000b\u0005uA\u0011aB2p[6|gn]\u0005\u0003?i\u0011!\u0002R5ta>\u001c\u0018M\u00197f!\t\tC%D\u0001#\u0015\t\u0019C$A\u0004m_\u001e<\u0017N\\4\n\u0005\u0015\u0012#a\u0002'pO\u001eLgn\u001a\u0005\u0006O\u0001!\t\u0001K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0002\"!\u0006\u0001\t\u0013-\u0002\u0001\u0019!a\u0001\n\u0003a\u0013aA;sYV\tQ\u0006\u0005\u0002/c9\u0011qbL\u0005\u0003aA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001\u0007\u0005\u0005\nk\u0001\u0001\r\u00111A\u0005\u0002Y\nq!\u001e:m?\u0012*\u0017\u000f\u0006\u00028uA\u0011q\u0002O\u0005\u0003sA\u0011A!\u00168ji\"91\bNA\u0001\u0002\u0004i\u0013a\u0001=%c!1Q\b\u0001Q!\n5\nA!\u001e:mA!Iq\b\u0001a\u0001\u0002\u0004%\t\u0001L\u0001\tkN,'OT1nK\"I\u0011\t\u0001a\u0001\u0002\u0004%\tAQ\u0001\rkN,'OT1nK~#S-\u001d\u000b\u0003o\rCqa\u000f!\u0002\u0002\u0003\u0007Q\u0006\u0003\u0004F\u0001\u0001\u0006K!L\u0001\nkN,'OT1nK\u0002B\u0011b\u0012\u0001A\u0002\u0003\u0007I\u0011\u0001\u0017\u0002\u0011A\f7o]<pe\u0012D\u0011\"\u0013\u0001A\u0002\u0003\u0007I\u0011\u0001&\u0002\u0019A\f7o]<pe\u0012|F%Z9\u0015\u0005]Z\u0005bB\u001eI\u0003\u0003\u0005\r!\f\u0005\u0007\u001b\u0002\u0001\u000b\u0015B\u0017\u0002\u0013A\f7o]<pe\u0012\u0004\u0003\"C(\u0001\u0001\u0004\u0005\r\u0011\"\u0001-\u0003\u0011\u0011\u0017m]3\t\u0013E\u0003\u0001\u0019!a\u0001\n\u0003\u0011\u0016\u0001\u00032bg\u0016|F%Z9\u0015\u0005]\u001a\u0006bB\u001eQ\u0003\u0003\u0005\r!\f\u0005\u0007+\u0002\u0001\u000b\u0015B\u0017\u0002\u000b\t\f7/\u001a\u0011\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0003A\u0016aA2uqV\t\u0011\f\u0005\u0002[C6\t1L\u0003\u0002];\u0006IA-\u001b:fGR|'/\u001f\u0006\u0003=~\u000baA\\1nS:<'\"\u00011\u0002\u000b)\fg/\u0019=\n\u0005\t\\&A\u0003#je\u000e{g\u000e^3yi\"IA\r\u0001a\u0001\u0002\u0004%\t!Z\u0001\bGRDx\fJ3r)\t9d\rC\u0004<G\u0006\u0005\t\u0019A-\t\r!\u0004\u0001\u0015)\u0003Z\u0003\u0011\u0019G\u000f\u001f\u0011\t\u000f)\u0004\u0001\u0019!C\u0005W\u00069Q/\u001b3OC6,W#\u00017\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018\u0001\u00027b]\u001eT\u0011!]\u0001\u0005U\u00064\u0018-\u0003\u00023]\"9A\u000f\u0001a\u0001\n\u0013)\u0018aC;jI:\u000bW.Z0%KF$\"a\u000e<\t\u000fm\u001a\u0018\u0011!a\u0001Y\"1\u0001\u0010\u0001Q!\n1\f\u0001\"^5e\u001d\u0006lW\r\t\u0005\bu\u0002\u0001\r\u0011\"\u0003|\u0003)\u0001(o\u001c9feRLWm]\u000b\u0002yB)Q0!\u0001.[5\taP\u0003\u0002\u0000a\u0006!Q\u000f^5m\u0013\r\t\u0019A \u0002\n\u0011\u0006\u001c\b\u000e^1cY\u0016D\u0011\"a\u0002\u0001\u0001\u0004%I!!\u0003\u0002\u001dA\u0014x\u000e]3si&,7o\u0018\u0013fcR\u0019q'a\u0003\t\u0011m\n)!!AA\u0002qDq!a\u0004\u0001A\u0003&A0A\u0006qe>\u0004XM\u001d;jKN\u0004\u0003BB\u0014\u0001\t\u0003\t\u0019\u0002F\u0005*\u0003+\t9\"!\u0007\u0002\u001c!11&!\u0005A\u00025BaaPA\t\u0001\u0004i\u0003BB$\u0002\u0012\u0001\u0007Q\u0006\u0003\u0004P\u0003#\u0001\r!\f\u0005\b\u0003?\u0001A\u0011AA\u0011\u0003%9W\r^+tKJ$e\nF\u0002.\u0003GAq!!\n\u0002\u001e\u0001\u0007Q&A\u0002vS\u0012Dq!!\u000b\u0001\t\u0003\tY#A\u0006hKR\u0004\u0016m]:x_J$GcA\u0017\u0002.!9\u0011QEA\u0014\u0001\u0004i\u0003bBA\u0019\u0001\u0011\u0005\u00111G\u0001\u000eO\u0016$\u0018\t\u001e;sS\n,H/Z:\u0015\r\u0005U\u0012\u0011IA\"!\u0015q\u0013qGA\u001e\u0013\r\tId\r\u0002\u0004'\u0016$\bcA\b\u0002>%\u0019\u0011q\b\t\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002&\u0005=\u0002\u0019A\u0017\t\u000f\u0005\u0015\u0013q\u0006a\u0001[\u0005A\u0011\r\u001e;s\u001d\u0006lW\r\u0003\u0004\u0002J\u0001!Ia_\u0001\u000bK:4\u0018N]8nK:$\bbBA'\u0001\u0011%\u0011qJ\u0001\bG>tg.Z2u)\u0005I\u0006bBA*\u0001\u0011\u0005\u0011QK\u0001\u000bI&\u001c8i\u001c8oK\u000e$H#A\u001c\t\r\u0005e\u0003\u0001\"\u0003Y\u0003\u001d\u0019wN\u001c;fqRDq!!\u0018\u0001\t\u0003\n)&A\u0004eKN$(o\\=\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002d\u0005!An\\1e)\u0011\t)'a\u001e\u0011\u000b=\t9'a\u001b\n\u0007\u0005%\u0004C\u0001\u0004PaRLwN\u001c\t\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)\u0019\u0011\u0011\u000f\u0004\u0002\u000b\u0005,H\u000f[2\n\t\u0005U\u0014q\u000e\u0002\b\u0003\u000e\u001cw.\u001e8u\u0011!\tI(a\u0018A\u0002\u0005m\u0012!\u00039sS:\u001c\u0017\u000e]1m\u0001")
public class SimpleLdapUserStore
implements LdapUserStore,
Disposable,
Logging {
    private String url;
    private String userName;
    private String password;
    private String base;
    private DirContext ctx;
    private String uidName;
    private Hashtable<String, String> properties;
    private final Logger org$beangle$commons$logging$Logging$$logger;

    public Logger org$beangle$commons$logging$Logging$$logger() {
        return this.org$beangle$commons$logging$Logging$$logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$org$beangle$commons$logging$Logging$$logger_$eq(Logger x$1) {
        this.org$beangle$commons$logging$Logging$$logger = x$1;
    }

    public final boolean debugEnabled() {
        return Logging.class.debugEnabled((Logging)this);
    }

    public final void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public final void trace(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public final void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public final void debug(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public final void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public final void info(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public final void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public final void warn(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    public final void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public final void error(Function0<String> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    @Override
    public String url() {
        return this.url;
    }

    public void url_$eq(String x$1) {
        this.url = x$1;
    }

    public String userName() {
        return this.userName;
    }

    public void userName_$eq(String x$1) {
        this.userName = x$1;
    }

    public String password() {
        return this.password;
    }

    public void password_$eq(String x$1) {
        this.password = x$1;
    }

    public String base() {
        return this.base;
    }

    public void base_$eq(String x$1) {
        this.base = x$1;
    }

    public DirContext ctx() {
        return this.ctx;
    }

    public void ctx_$eq(DirContext x$1) {
        this.ctx = x$1;
    }

    private String uidName() {
        return this.uidName;
    }

    private void uidName_$eq(String x$1) {
        this.uidName = x$1;
    }

    private Hashtable<String, String> properties() {
        return this.properties;
    }

    private void properties_$eq(Hashtable<String, String> x$1) {
        this.properties = x$1;
    }

    @Override
    public String getUserDN(String uid) {
        DirContext ctx = this.context();
        if (ctx == null) {
            return null;
        }
        String result = null;
        String condition = Strings$.MODULE$.concat((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uidName(), "=", uid}));
        try {
            String[] attrList = (String[])((Object[])new String[]{this.uidName()});
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(2);
            constraints.setReturningAttributes(attrList);
            NamingEnumeration<SearchResult> results = ctx.search(this.base(), condition, constraints);
            if (results.hasMore()) {
                SearchResult si = results.next();
                result = Strings$.MODULE$.concat((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{si.getName(), ",", this.base()}));
            }
            results.close();
            results = null;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this, uid){
                private final String uid$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Ldap search error,uid=").append((Object)this.uid$1).toString();
                }
                {
                    this.uid$1 = uid$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
        }
        return result;
    }

    @Override
    public String getPassword(String uid) {
        Set<Object> passwords = this.getAttributes(uid, "userPassword");
        if (passwords.isEmpty()) {
            return null;
        }
        return new String((byte[])passwords.head());
    }

    @Override
    public Set<Object> getAttributes(String uid, String attrName) {
        HashSet values = new HashSet();
        DirContext ctx = this.context();
        if (ctx != null) {
            try {
                String dn = this.getUserDN(uid);
                if (dn == null) {
                    this.debug((Function0<String>)new Serializable(this, uid){
                        private final String uid$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uid$2}));
                        }
                        {
                            this.uid$2 = uid$2;
                        }
                    });
                } else {
                    CompositeName userID = new CompositeName(dn);
                    Attributes attrs = attrName == null ? ctx.getAttributes(userID) : ctx.getAttributes(userID, (String[])((Object[])new String[]{attrName}));
                    NamingEnumeration<? extends Attribute> attrEnum = attrs.getAll();
                    while (attrEnum.hasMoreElements()) {
                        values.$plus$eq(((Attribute)attrEnum.nextElement()).get());
                    }
                }
            }
            catch (NamingException namingException) {
                namingException.printStackTrace();
            }
        }
        return values.toSet();
    }

    /*
     * WARNING - void declaration
     */
    private Hashtable<String, String> enviroment() {
        void var1_1;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.url());
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.userName());
        env.put("java.naming.security.credentials", this.password());
        return var1_1;
    }

    private synchronized DirContext connect() {
        Hashtable<String, String> env = this.enviroment();
        env.putAll(this.properties());
        try {
            this.ctx_$eq(new InitialDirContext(env));
            this.debug((Function0<String>)new Serializable(this){

                public final String apply() {
                    return "Ldap server connect success.";
                }
            });
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(this){

                public final String apply() {
                    return "Ldap server connect failure";
                }
            }, (Function0<Throwable>)new Serializable(this, exception){
                private final Exception e$2;

                public final Exception apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            });
        }
        return this.ctx();
    }

    public synchronized void disConnect() {
        if (this.ctx() != null) {
            try {
                this.ctx().close();
                this.ctx_$eq(null);
                this.debug((Function0<String>)new Serializable(this){

                    public final String apply() {
                        return "Ldap connect closed.";
                    }
                });
            }
            catch (Exception exception) {
                this.error((Function0<String>)new Serializable(this){

                    public final String apply() {
                        return "Failure to close ldap connection.";
                    }
                }, (Function0<Throwable>)new Serializable(this, exception){
                    private final Exception e$3;

                    public final Exception apply() {
                        return this.e$3;
                    }
                    {
                        this.e$3 = e$3;
                    }
                });
            }
        }
    }

    private DirContext context() {
        return this.ctx() == null ? this.connect() : this.ctx();
    }

    public void destroy() {
        this.disConnect();
    }

    @Override
    public Option<Account> load(Object principal) {
        None$ none$;
        String dn = this.getUserDN(principal.toString());
        if (dn == null) {
            none$ = None$.MODULE$;
        } else {
            DefaultAccount account = new DefaultAccount(principal, dn);
            none$ = new Some((Object)account);
        }
        return none$;
    }

    public SimpleLdapUserStore() {
        Logging.class.$init$((Logging)this);
        this.uidName = "uid";
        this.properties = new Hashtable();
    }

    public SimpleLdapUserStore(String url, String userName, String password, String base) {
        this();
        Predef$.MODULE$.assert(url != null);
        Predef$.MODULE$.assert(userName != null);
        Predef$.MODULE$.assert(password != null);
        Predef$.MODULE$.assert(base != null);
        this.url_$eq(url);
        this.userName_$eq(userName);
        this.password_$eq(password);
        this.base_$eq(base);
    }
}

