/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.web.servlet.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import java.util.Enumeration;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.bean.Properties$;
import org.beangle.commons.lang.Strings$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashSet;

public abstract class GenericHttpFilter
implements Filter,
Initializing {
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.initParams(filterConfig, this.requiredProperties());
        this.init();
    }

    private final void initParams(FilterConfig config, Set<String> requiredProperties) {
        HashSet missingProps = new HashSet();
        if (requiredProperties != null && requiredProperties.nonEmpty()) {
            missingProps.$plus$plus$eq(requiredProperties);
        }
        Enumeration en = config.getInitParameterNames();
        while (en.hasMoreElements()) {
            String property = (String)en.nextElement();
            String value = config.getInitParameter(property);
            Properties$.MODULE$.copy((Object)this, property, (Object)value);
            missingProps.remove((Object)property);
        }
        if (missingProps.nonEmpty()) {
            throw new ServletException("Initialization from FilterConfig for filter '" + config.getFilterName() + "' failed; the following required properties were missing: " + Strings$.MODULE$.join((Iterable)missingProps, ", "));
        }
    }

    public String filterName() {
        if (this.filterConfig != null) {
            return this.filterConfig.getFilterName();
        }
        return "None";
    }

    public void init() {
    }

    public FilterConfig config() {
        return this.filterConfig;
    }

    public Set<String> requiredProperties() {
        return Predef$.MODULE$.Set().empty();
    }

    public void destroy() {
    }
}

