/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.web.servlet.filter;

import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Pattern;
import org.beangle.web.servlet.filter.RequestMatcher;
import org.beangle.web.servlet.util.RequestUtils$;
import scala.collection.mutable.StringBuilder;

public class RegexRequestMatcher
implements RequestMatcher {
    private final Pattern pattern;
    private final String method;

    public RegexRequestMatcher(Pattern pattern, String method) {
        this.pattern = pattern;
        this.method = method;
    }

    public RegexRequestMatcher(String patternStr, String method, boolean caseInsensitive) {
        this(caseInsensitive ? Pattern.compile(patternStr, 2) : Pattern.compile(patternStr), method);
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        if (this.method != null) {
            String string = this.method;
            String string2 = request.getMethod();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
        }
        String url = RequestUtils$.MODULE$.getServletPath(request);
        String pathInfo = request.getPathInfo();
        String query = request.getQueryString();
        if (pathInfo != null || query != null) {
            StringBuilder sb = new StringBuilder(url);
            if (pathInfo != null) {
                sb.append(pathInfo);
            }
            if (query != null) {
                sb.append(query);
            }
            url = sb.toString();
        }
        return this.pattern.matcher(url).matches();
    }
}

