/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.web.servlet.http.agent;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.beangle.commons.lang.Strings$;
import org.beangle.web.servlet.http.agent.BrowserCategory$;
import org.beangle.web.servlet.http.agent.Engine;
import scala.Function1;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.reflect.Enum;

public abstract class BrowserCategory
implements Product,
Enum {
    private final String name;
    private final Engine engine;
    private final List<Tuple2<Pattern, String>> versionPairs;

    public static BrowserCategory fromOrdinal(int n) {
        return BrowserCategory$.MODULE$.fromOrdinal(n);
    }

    public static BrowserCategory valueOf(String string) {
        return BrowserCategory$.MODULE$.valueOf(string);
    }

    public static BrowserCategory[] values() {
        return BrowserCategory$.MODULE$.values();
    }

    public BrowserCategory(String versions, Engine engine2, Seq<String> seq) {
        this.name = name;
        this.engine = (Engine)engine;
        this.versionPairs = this.build((Seq<String>)versions);
        engine.addCategory(this);
    }

    public String name() {
        return this.name;
    }

    public Engine engine() {
        return this.engine;
    }

    private List<Tuple2<Pattern, String>> build(Seq<String> versions) {
        ListBuffer pairs = new ListBuffer();
        versions.foreach((Function1 & Serializable)version -> {
            Object matcheTarget = version;
            String versionNum = "";
            if (Strings$.MODULE$.contains((CharSequence)version, (CharSequence)"->")) {
                matcheTarget = "(?i)" + Strings$.MODULE$.substringBefore(version, "->");
                versionNum = Strings$.MODULE$.substringAfter(version, "->");
            }
            return (ListBuffer)pairs.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)Pattern.compile((String)matcheTarget), (Object)versionNum));
        });
        return pairs.toList();
    }

    public String matches(String agentString) {
        String matched = null;
        Iterator pairIter = this.versionPairs.iterator();
        while (pairIter.hasNext() && matched == null) {
            Tuple2 pair = (Tuple2)pairIter.next();
            Matcher m = ((Pattern)pair._1()).matcher(agentString);
            if (!m.find()) continue;
            StringBuffer sb = new StringBuffer();
            m.appendReplacement(sb, (String)pair._2());
            sb.delete(0, m.start());
            matched = sb.toString();
        }
        return matched;
    }
}

