/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.web.servlet.io;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.web.servlet.io.DefaultWagon;
import scala.Int$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class RangedWagon
extends DefaultWagon {
    @Override
    public void copy(InputStream input, HttpServletRequest req, HttpServletResponse res) {
        res.setHeader("Accept-Ranges", "bytes");
        res.setHeader("connection", "Keep-Alive");
        int length = 0;
        long start = 0L;
        long begin = 0L;
        long stop = 0L;
        try {
            length = input.available();
            stop = Int$.MODULE$.int2long(length - 1);
            res.setContentLength(length);
            String rangestr = req.getHeader("Range");
            if (rangestr != null) {
                String[] readlength = Strings$.MODULE$.substringAfter(rangestr, "bytes=").split("-");
                start = Long.parseLong(readlength[0]);
                if (readlength.length > 1 && Strings$.MODULE$.isNotEmpty((CharSequence)readlength[1])) {
                    stop = Long.parseLong(readlength[1]);
                }
                if (start != 0L) {
                    res.setStatus(206);
                    String crange = "bytes " + start + "-" + stop + "/" + length;
                    res.setHeader("Content-Range", crange);
                }
            }
            ServletOutputStream output = res.getOutputStream();
            input.skip(start);
            begin = start;
            int size = 4096;
            byte[] buffer = new byte[size];
            int step = this.maxStep(start, stop, size);
            while (step > 0) {
                int readed = input.read(buffer, 0, step);
                if (readed == -1) {
                    step = 0;
                    continue;
                }
                output.write(buffer, 0, readed);
                step = this.maxStep(start += (long)readed, stop, size);
            }
        }
        catch (Throwable throwable) {
            IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input}));
            throw throwable;
        }
        IOs$.MODULE$.close((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{input}));
    }

    public int maxStep(long start, long stop, int bufferSize) {
        if (stop - start + 1L >= (long)bufferSize) {
            return bufferSize;
        }
        return (int)(stop - start + 1L);
    }
}

