/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.web.servlet.multipart;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.lang.Strings$;
import org.beangle.web.servlet.multipart.MultipartResolver;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class StandardMultipartResolver$
implements MultipartResolver,
Serializable {
    public static final StandardMultipartResolver$ MODULE$ = new StandardMultipartResolver$();

    private StandardMultipartResolver$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(StandardMultipartResolver$.class);
    }

    @Override
    public boolean isMultipart(HttpServletRequest request) {
        if ("post".equals(request.getMethod().toLowerCase())) {
            String contentType = request.getContentType();
            return contentType != null && contentType.toLowerCase().startsWith("multipart/");
        }
        return false;
    }

    @Override
    public Map<String, Object> resolve(HttpServletRequest request) {
        Iterator partItor = request.getParts().iterator();
        HashMap params = new HashMap();
        while (partItor.hasNext()) {
            Part part = (Part)partItor.next();
            if (part.getSize() > 0L) {
                String disposition = part.getHeader("content-disposition");
                if (disposition.contains("filename=")) {
                    this.updatePart((scala.collection.mutable.Map<String, Object>)params, part.getName(), part);
                    continue;
                }
                String paramName = Strings$.MODULE$.substringBetween(disposition, "name=\"", "\"");
                this.updateString((scala.collection.mutable.Map<String, Object>)params, paramName, part);
                continue;
            }
            if (!this.isFormField(part) || params.contains((Object)part.getName())) continue;
            params.put((Object)part.getName(), (Object)"");
        }
        return params.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void updateString(scala.collection.mutable.Map<String, Object> params, String name, Part part) {
        Object[] objectArray;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        IOs$.MODULE$.copy(part.getInputStream(), (OutputStream)b);
        Object[] str = new String(b.toByteArray());
        Option option = params.get((Object)name);
        if (option instanceof Some) {
            Object v = ((Some)option).value();
            Object object = v;
            if (object instanceof Object[]) {
                Object[] a = (Object[])object;
                objectArray = (Object[])Array$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Object[][]{(Object[])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{str}), ClassTag$.MODULE$.Any()), a}), ClassTag$.MODULE$.Any());
            } else {
                objectArray = (Object[])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{v, str}), ClassTag$.MODULE$.Any());
            }
        } else if (None$.MODULE$.equals(option)) {
            objectArray = str;
        } else {
            throw new MatchError((Object)option);
        }
        Object[] newValue = objectArray;
        params.put((Object)name, (Object)newValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updatePart(scala.collection.mutable.Map<String, Object> params, String name, Part part) {
        Part[] partArray;
        Option option = params.get((Object)name);
        if (option instanceof Some) {
            Object arr = ((Some)option).value();
            Object object = arr;
            if (object instanceof String) {
                partArray = new Part[]{part};
            } else {
                if (!(object instanceof Part[])) throw new MatchError(object);
                Part[] a = (Part[])object;
                partArray = (Part[])Array$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Part[][]{{part}, a}), ClassTag$.MODULE$.apply(Part.class));
            }
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            partArray = new Part[]{part};
        }
        Part[] newParts = partArray;
        params.put((Object)name, (Object)newParts);
    }

    private boolean isFormField(Part part) {
        return !"application/octet-stream".equals(part.getContentType()) && !part.getHeader("content-disposition").contains("filename");
    }

    @Override
    public void cleanup(HttpServletRequest request) {
        if (this.isMultipart(request)) {
            Iterator partItor = request.getParts().iterator();
            while (partItor.hasNext()) {
                ((Part)partItor.next()).delete();
            }
            return;
        }
    }
}

