/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.web.servlet.resource;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import org.beangle.commons.activation.MediaType;
import org.beangle.commons.activation.MediaTypes$;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.io.ResourceLoader;
import org.beangle.commons.lang.Strings$;
import org.beangle.web.servlet.resource.PathResolver$;
import org.beangle.web.servlet.resource.ProcessChain;
import org.beangle.web.servlet.resource.ProcessContext;
import org.beangle.web.servlet.resource.ResourceFilter;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.function.JProcedure1;

public class ResourceProcessor {
    private final ResourceLoader loader;
    private List filters;

    public ResourceProcessor(ResourceLoader loader) {
        this.loader = loader;
        this.filters = package$.MODULE$.List().empty();
    }

    private ResourceLoader loader() {
        return this.loader;
    }

    public List<ResourceFilter> filters() {
        return this.filters;
    }

    public void filters_$eq(List<ResourceFilter> x$1) {
        this.filters = x$1;
    }

    public void process(String uri, HttpServletRequest request, HttpServletResponse response) {
        Seq<String> names = PathResolver$.MODULE$.resolve(uri);
        List resources = this.loader().load(names);
        if (resources.size() != names.size()) {
            response.sendError(404);
            return;
        }
        ProcessContext pc = new ProcessContext(uri, names, (Seq<URL>)resources);
        response.setContentType(this.getContentType(pc.uri(), request));
        ProcessChain chain = new ProcessChain((Iterator<ResourceFilter>)this.filters().iterator());
        chain.process(pc, request, response);
        if (response.getStatus() == 200) {
            boolean isText = response.getContentType() != null && response.getContentType().startsWith("text/");
            ServletOutputStream os = response.getOutputStream();
            pc.resources().foreach((Function1)(JProcedure1 & Serializable)res -> {
                InputStream is = res.url().openStream();
                IOs$.MODULE$.copy(is, (OutputStream)os);
                is.close();
                if (isText) {
                    os.write(10);
                    return;
                }
            });
            return;
        }
    }

    public String getContentType(String uri, HttpServletRequest request) {
        MediaType contentType = (MediaType)MediaTypes$.MODULE$.get(Strings$.MODULE$.substringAfterLast(uri, ".")).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (contentType == null) {
            return request.getServletContext().getMimeType(uri);
        }
        return contentType.toString();
    }
}

