/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.web.servlet.resource.filter;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import org.beangle.web.servlet.resource.ProcessChain;
import org.beangle.web.servlet.resource.ProcessContext;
import org.beangle.web.servlet.resource.ResourceFilter;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.runtime.IntRef;
import scala.runtime.function.JProcedure1;

public class HeaderFilter
implements ResourceFilter {
    private int expireDays = 7;

    public int expireDays() {
        return this.expireDays;
    }

    public void expireDays_$eq(int x$1) {
        this.expireDays = x$1;
    }

    @Override
    public void filter(ProcessContext context, HttpServletRequest request, HttpServletResponse response, ProcessChain chain) {
        IntRef maxLastModified = IntRef.create((int)-1);
        context.resources().foreach((Function1)(JProcedure1 & Serializable)res -> {
            long lastModified0 = this.lastModified(res.url());
            if (lastModified0 > (long)maxLastModified$1.elem) {
                int n;
                maxLastModified$1.elem = n = Predef$.MODULE$.long2Long(lastModified0).intValue();
                return;
            }
        });
        String requestETag = request.getHeader("If-None-Match");
        String newETag = String.valueOf(maxLastModified.elem);
        response.setHeader("ETag", newETag);
        if (newETag.equals(requestETag)) {
            response.setStatus(304);
            return;
        }
        chain.process(context, request, response);
        Calendar cal = Calendar.getInstance();
        cal.add(5, this.expireDays());
        long expires = cal.getTimeInMillis();
        response.setDateHeader("Date", System.currentTimeMillis());
        response.setDateHeader("Expires", expires);
        response.setDateHeader("Retry-After", expires);
        response.setHeader("Cache-Control", "public");
        if (maxLastModified.elem > 0) {
            response.setDateHeader("Last-Modified", Int$.MODULE$.int2long(maxLastModified.elem));
            return;
        }
    }

    private long lastModified(URL url) {
        long l;
        block4: {
            if (url.getProtocol().equals("file")) {
                return new File(url.getFile()).lastModified();
            }
            try {
                URLConnection conn;
                URLConnection uRLConnection = conn = url.openConnection();
                if (uRLConnection instanceof JarURLConnection) {
                    JarURLConnection jarConn = (JarURLConnection)uRLConnection;
                    URL jarURL = jarConn.getJarFileURL();
                    l = jarURL.getProtocol().equals("file") ? new File(jarURL.getFile()).lastModified() : -1L;
                    break block4;
                }
                l = -1L;
            }
            catch (IOException e) {
                l = -1L;
            }
        }
        return l;
    }
}

