/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.web.servlet.url;

import jakarta.servlet.http.HttpServletRequest;
import org.beangle.web.servlet.url.UrlBuilder$;
import scala.collection.mutable.StringBuilder;

public class UrlBuilder {
    private String scheme;
    private String serverName;
    private int port;
    private String contextPath;
    private String servletPath;
    private String requestURI;
    private String pathInfo;
    private String queryString;

    public static UrlBuilder apply(HttpServletRequest httpServletRequest) {
        return UrlBuilder$.MODULE$.apply(httpServletRequest);
    }

    public static String url(HttpServletRequest httpServletRequest) {
        return UrlBuilder$.MODULE$.url(httpServletRequest);
    }

    public UrlBuilder(String cxtPath) {
        String string = cxtPath;
        String string2 = "/";
        this.contextPath = !(string != null ? !string.equals(string2) : string2 != null) ? "" : cxtPath;
    }

    public String scheme() {
        return this.scheme;
    }

    public void scheme_$eq(String x$1) {
        this.scheme = x$1;
    }

    public String serverName() {
        return this.serverName;
    }

    public void serverName_$eq(String x$1) {
        this.serverName = x$1;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int x$1) {
        this.port = x$1;
    }

    public String contextPath() {
        return this.contextPath;
    }

    public void contextPath_$eq(String x$1) {
        this.contextPath = x$1;
    }

    public String servletPath() {
        return this.servletPath;
    }

    public void servletPath_$eq(String x$1) {
        this.servletPath = x$1;
    }

    public String requestURI() {
        return this.requestURI;
    }

    public void requestURI_$eq(String x$1) {
        this.requestURI = x$1;
    }

    public String pathInfo() {
        return this.pathInfo;
    }

    public void pathInfo_$eq(String x$1) {
        this.pathInfo = x$1;
    }

    public String queryString() {
        return this.queryString;
    }

    public void queryString_$eq(String x$1) {
        this.queryString = x$1;
    }

    private String buildServletPath() {
        String uri = this.servletPath();
        if (uri == null && this.requestURI() != null) {
            uri = this.requestURI();
            String string = this.contextPath();
            String string2 = "";
            if (string == null ? string2 != null : !string.equals(string2)) {
                uri = uri.substring(this.contextPath().length());
            }
        }
        if (uri == null) {
            return "";
        }
        return uri;
    }

    public String buildOrigin() {
        boolean includePort;
        StringBuilder sb = new StringBuilder();
        sb.append(this.scheme()).append("://");
        sb.append(this.serverName());
        String string = this.scheme();
        String string2 = "http";
        boolean bl = includePort = this.port() != (!(string != null ? !string.equals(string2) : string2 != null) ? 80 : 443);
        if (includePort && this.port() > 0) {
            sb.append(':').append(this.port());
        }
        return sb.toString();
    }

    public String buildRequestUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildServletPath());
        if (this.pathInfo() != null) {
            sb.append(this.pathInfo());
        }
        if (this.queryString() != null) {
            sb.append('?').append(this.queryString());
        }
        return sb.toString();
    }

    public String buildUrl() {
        StringBuilder sb = new StringBuilder();
        boolean includePort = true;
        if (this.scheme() != null) {
            sb.append(this.scheme()).append("://");
            String string = this.scheme();
            String string2 = "http";
            boolean bl = includePort = this.port() != (!(string != null ? !string.equals(string2) : string2 != null) ? 80 : 443);
        }
        if (this.serverName() != null) {
            sb.append(this.serverName());
            if (includePort && this.port() > 0) {
                sb.append(':').append(this.port());
            }
        }
        sb.append(this.contextPath());
        sb.append(this.buildRequestUrl());
        return sb.toString();
    }

    public UrlBuilder setScheme(String scheme) {
        this.scheme_$eq(scheme);
        return this;
    }

    public UrlBuilder setServerName(String serverName) {
        this.serverName_$eq(serverName);
        return this;
    }

    public UrlBuilder setPort(int port) {
        this.port_$eq(port);
        return this;
    }

    public UrlBuilder setContextPath(String contextPath) {
        this.contextPath_$eq(contextPath);
        return this;
    }

    public UrlBuilder setServletPath(String servletPath) {
        this.servletPath_$eq(servletPath);
        return this;
    }

    public UrlBuilder setRequestURI(String requestURI) {
        this.requestURI_$eq(requestURI);
        return this;
    }

    public UrlBuilder setPathInfo(String pathInfo) {
        this.pathInfo_$eq(pathInfo);
        return this;
    }

    public UrlBuilder setQueryString(String queryString) {
        this.queryString_$eq(queryString);
        return this;
    }
}

