/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.web.servlet.util;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.beangle.commons.lang.Strings$;
import org.beangle.web.servlet.url.UrlBuilder;

public class CookieGenerator {
    private final String name;
    private String domain;
    private String path;
    private boolean secure;
    private boolean httpOnly;
    private int maxAge;
    private int port;

    public CookieGenerator(String name) {
        this.name = name;
        this.httpOnly = true;
        this.maxAge = -1;
        this.port = 80;
    }

    public String name() {
        return this.name;
    }

    public String domain() {
        return this.domain;
    }

    public void domain_$eq(String x$1) {
        this.domain = x$1;
    }

    public String path() {
        return this.path;
    }

    public void path_$eq(String x$1) {
        this.path = x$1;
    }

    public boolean secure() {
        return this.secure;
    }

    public void secure_$eq(boolean x$1) {
        this.secure = x$1;
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public void httpOnly_$eq(boolean x$1) {
        this.httpOnly = x$1;
    }

    public int maxAge() {
        return this.maxAge;
    }

    public void maxAge_$eq(int x$1) {
        this.maxAge = x$1;
    }

    public int port() {
        return this.port;
    }

    public void port_$eq(int x$1) {
        this.port = x$1;
    }

    public void addCookie(HttpServletRequest request, HttpServletResponse response, String value) {
        Cookie cookie = this.createCookie(request, value);
        cookie.setMaxAge(this.maxAge());
        cookie.setSecure(this.secure());
        cookie.setHttpOnly(this.httpOnly());
        response.addCookie(cookie);
    }

    public void removeCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = this.createCookie(request, "");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public Cookie createCookie(HttpServletRequest request, String value) {
        Cookie cookie = new Cookie(this.name(), value);
        if (this.domain() != null) {
            String string = request.getServerName();
            String string2 = this.domain();
            if (string == null ? string2 != null : !string.equals(string2)) {
                cookie.setDomain(this.domain());
            }
        }
        cookie.setPath(this.path());
        return cookie;
    }

    public void base_$eq(String baseUrl) {
        String b = Strings$.MODULE$.trim(baseUrl);
        if (baseUrl.contains("https://")) {
            this.secure_$eq(true);
            b = Strings$.MODULE$.replace(b, "https://", "");
        } else {
            b = Strings$.MODULE$.replace(b, "http://", "");
        }
        int pathIdx = b.indexOf(47);
        if (-1 == pathIdx) {
            this.path_$eq("/");
        } else {
            this.path_$eq(b.substring(pathIdx));
            b = b.substring(0, pathIdx);
        }
        int portIdx = b.indexOf(58);
        if (-1 == portIdx) {
            if (this.secure()) {
                this.port_$eq(443);
            }
        } else {
            this.port_$eq(Integer.parseInt(b.substring(portIdx + 1)));
            b = b.substring(0, portIdx);
        }
        this.domain_$eq(b);
    }

    public String base() {
        UrlBuilder b = new UrlBuilder("");
        b.setServletPath(this.path());
        b.setServerName(this.domain());
        b.setPort(this.port());
        b.setScheme(this.secure() ? "https" : "http");
        return b.buildUrl();
    }
}

