/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.web.servlet.util;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.beangle.web.servlet.util.RequestUtils$;
import scala.runtime.ModuleSerializationProxy;

public final class CookieUtils$
implements Serializable {
    private static final String Encoding;
    public static final CookieUtils$ MODULE$;

    private CookieUtils$() {
    }

    static {
        MODULE$ = new CookieUtils$();
        Encoding = "utf-8";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CookieUtils$.class);
    }

    public String getCookieValue(Cookie cookie) {
        return this.decode(cookie.getValue());
    }

    public String getCookieValue(HttpServletRequest request, String cookieName) {
        Cookie cookie = this.getCookie(request, cookieName);
        if (cookie == null) {
            return null;
        }
        return this.decode(cookie.getValue());
    }

    public Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        Cookie returnCookie = null;
        for (int i = 0; i < cookies.length && returnCookie == null; ++i) {
            Cookie thisCookie = cookies[i];
            String string = thisCookie.getName();
            String string2 = name;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            String string3 = thisCookie.getValue();
            String string4 = "";
            if (!(string3 == null ? string4 != null : !string3.equals(string4))) continue;
            returnCookie = thisCookie;
        }
        return returnCookie;
    }

    public void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, String path, int age) {
        Cookie cookie = new Cookie(name, URLEncoder.encode(value, Encoding));
        boolean secure = RequestUtils$.MODULE$.isHttps(request);
        cookie.setSecure(secure);
        cookie.setPath(path);
        cookie.setMaxAge(age);
        cookie.setHttpOnly(true);
        if (secure) {
            cookie.setAttribute("SameSite", "None");
        }
        response.addCookie(cookie);
    }

    public void addCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int age) {
        String path = this.getPath(request);
        this.addCookie(request, response, name, value, path, age);
    }

    public boolean deleteCookieByName(HttpServletRequest request, HttpServletResponse response, String name) {
        String path = this.getPath(request);
        return this.deleteCookie(response, this.getCookie(request, name), path);
    }

    public boolean deleteCookie(HttpServletResponse response, Cookie cookie, String path) {
        if (cookie == null) {
            return false;
        }
        cookie.setMaxAge(0);
        cookie.setPath(path);
        response.addCookie(cookie);
        return true;
    }

    public void clearSession(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            String contextPath = this.getPath(request);
            for (int i = 0; i < cookies.length; ++i) {
                Cookie c = cookies[i];
                if (c.getMaxAge() >= 0) continue;
                String domain = c.getDomain();
                if (domain != null) {
                    String string = domain;
                    String string2 = request.getServerName();
                    if (string != null ? !string.equals(string2) : string2 != null) continue;
                }
                this.deleteCookie(response, c, contextPath);
            }
            return;
        }
    }

    public String getPath(HttpServletRequest request) {
        if (request.getContextPath().length() == 0) {
            return "/";
        }
        return request.getContextPath();
    }

    private String decode(String cookieValue) {
        String string;
        try {
            string = URLDecoder.decode(cookieValue, Encoding);
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }
}

