/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.web.servlet.util;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Enumeration;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.web.servlet.http.agent.Browser$;
import org.beangle.web.servlet.http.agent.Os$;
import org.beangle.web.servlet.http.agent.Useragent;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;

public final class RequestUtils$
implements Serializable {
    public static final RequestUtils$ MODULE$ = new RequestUtils$();

    private RequestUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RequestUtils$.class);
    }

    public String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null) {
            return request.getRemoteAddr();
        }
        return ip;
    }

    public List<String> getProxies(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("x-forwarded-for");
        if (headers.hasMoreElements()) {
            String client = (String)headers.nextElement();
            Buffer proxies = Collections$.MODULE$.newBuffer();
            while (headers.hasMoreElements()) {
                proxies.$plus$eq(headers.nextElement());
            }
            proxies.$plus$eq((Object)request.getRemoteAddr());
            return proxies.toList();
        }
        return package$.MODULE$.List().empty();
    }

    public String getServletPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (Strings$.MODULE$.isNotEmpty((CharSequence)servletPath)) {
            return servletPath;
        }
        String uri = request.getRequestURI();
        if (uri.length() == 1) {
            return "";
        }
        String context = request.getContextPath();
        int length = context.length();
        if (length > 2) {
            int semicolonIdx;
            if ('/' == context.charAt(length - 1)) {
                context = context.substring(0, length - 1);
            }
            if ((semicolonIdx = (servletPath = uri.substring(context.length())).indexOf(59)) > 0) {
                return servletPath.substring(0, semicolonIdx);
            }
            return servletPath;
        }
        int semicolonIdx = uri.indexOf(59);
        if (semicolonIdx > 0) {
            return uri.substring(0, semicolonIdx);
        }
        return uri;
    }

    public void setContentDisposition(HttpServletResponse response, String attachName) {
        StringBuilder value = new StringBuilder("attachment;");
        value.$plus$plus$eq(" filename*=utf-8''" + URLEncoder.encode(attachName, "UTF-8").replaceAll("\\+", "%20"));
        response.setHeader("Content-Disposition", value.mkString());
    }

    public Useragent getUserAgent(HttpServletRequest request) {
        String head = request.getHeader("USER-AGENT");
        return new Useragent(this.getIpAddr(request), Browser$.MODULE$.parse(head), Os$.MODULE$.parse(head));
    }

    public boolean isHttps(HttpServletRequest req) {
        String string = req.getScheme();
        String string2 = "https";
        return !(string == null ? string2 != null : !string.equals(string2)) || "https".equals(req.getHeader("X-Forwarded-Proto"));
    }

    public int getServerPort(HttpServletRequest req) {
        String headPort = req.getHeader("X-Forwarded-Port");
        if (Strings$.MODULE$.isEmpty((CharSequence)headPort)) {
            return req.getServerPort();
        }
        return Integer.parseInt(headPort);
    }

    public boolean isAjax(HttpServletRequest request) {
        Enumeration headers = request.getHeaders("x-requested-with");
        while (headers.hasMoreElements()) {
            String header;
            String string = header = (String)headers.nextElement();
            String string2 = "XMLHttpRequest";
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }
}

