/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.webmvc.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.log.Logger;
import freemarker.template.utility.StringUtil;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.beangle.template.freemarker.URLTemplateSource;
import org.beangle.webmvc.freemarker.WebappTemplateLoader$;
import scala.MatchError;

public class WebappTemplateLoader
implements TemplateLoader {
    private final ServletContext servletContext;
    private final String subdirPath;
    private final Logger LOG;
    private final boolean attemptFileAccess;

    public static WebappTemplateLoader apply(ServletContext servletContext) {
        return WebappTemplateLoader$.MODULE$.apply(servletContext);
    }

    public static WebappTemplateLoader apply(ServletContext servletContext, String string) {
        return WebappTemplateLoader$.MODULE$.apply(servletContext, string);
    }

    public WebappTemplateLoader(ServletContext servletContext, String subdirPath) {
        this.servletContext = servletContext;
        this.subdirPath = subdirPath;
        this.LOG = Logger.getLogger((String)"freemarker.cache");
        this.attemptFileAccess = servletContext.getRealPath(subdirPath) != null;
    }

    public ServletContext servletContext() {
        return this.servletContext;
    }

    public String subdirPath() {
        return this.subdirPath;
    }

    public Object findTemplateSource(String name) throws IOException {
        String fullPath = this.subdirPath() + name;
        if (this.attemptFileAccess) {
            try {
                File file;
                String realPath = this.servletContext().getRealPath(fullPath);
                if (realPath != null && (file = new File(realPath)).canRead() && file.isFile()) {
                    return file;
                }
            }
            catch (SecurityException securityException) {}
        }
        URL url = null;
        try {
            url = this.servletContext().getResource(fullPath);
        }
        catch (MalformedURLException e) {
            this.LOG.warn("Could not retrieve resource " + StringUtil.jQuoteNoXSS((String)fullPath), (Throwable)e);
            return null;
        }
        return url == null ? null : new URLTemplateSource(url);
    }

    public long getLastModified(Object templateSource) {
        long l;
        Object object = templateSource;
        if (object instanceof File) {
            File f = (File)object;
            l = f.lastModified();
        } else if (object instanceof URLTemplateSource) {
            URLTemplateSource u = (URLTemplateSource)object;
            l = u.lastModified();
        } else {
            throw new MatchError(object);
        }
        return l;
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        InputStreamReader inputStreamReader;
        Object object = templateSource;
        if (object instanceof File) {
            File f = (File)object;
            inputStreamReader = new InputStreamReader(new FileInputStream(f));
        } else if (object instanceof URLTemplateSource) {
            URLTemplateSource u = (URLTemplateSource)object;
            inputStreamReader = new InputStreamReader(u.getInputStream(), encoding);
        } else {
            throw new MatchError(object);
        }
        return inputStreamReader;
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        block0: {
            Object object = templateSource;
            if (!(object instanceof URLTemplateSource)) break block0;
            URLTemplateSource u = (URLTemplateSource)object;
            u.close();
        }
    }

    public String toString() {
        return "(subdirPath=" + StringUtil.jQuote((String)this.subdirPath()) + ", servletContext={contextPath=" + StringUtil.jQuote((String)this.getContextPath()) + ", displayName=" + StringUtil.jQuote((String)this.servletContext().getServletContextName()) + "})";
    }

    private String getContextPath() {
        return this.servletContext().getContextPath();
    }
}

