/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.webmvc.showcase.action.config;

import java.io.Serializable;
import java.util.Locale;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.annotation.description;
import org.beangle.commons.lang.reflect.BeanInfos$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.commons.text.i18n.Messages;
import org.beangle.commons.text.i18n.Messages$;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.MessageSupport;
import org.beangle.web.action.support.ParamSupport;
import org.beangle.web.action.support.RouteSupport;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.config.ActionMapping;
import org.beangle.webmvc.config.Configurer;
import org.slf4j.Logger;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.math.Ordering;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@description(value="Beange WebMVC \u914d\u7f6e\u67e5\u770b\u5668")
public class MvcAction
implements MessageSupport,
RouteSupport,
ParamSupport,
Logging,
ActionSupport {
    private Logger logger;
    private Configurer configurer;

    public MvcAction() {
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }

    public Logger logger() {
        return this.logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Configurer configurer() {
        return this.configurer;
    }

    public void configurer_$eq(Configurer x$1) {
        this.configurer = x$1;
    }

    public View index() {
        this.put("namespaces", this.getNamespaces());
        return this.forward(this.forward$default$1());
    }

    public View profiles() {
        this.put("profiles", this.configurer().profiles());
        return this.forward(this.forward$default$1());
    }

    public View actions() {
        String namespace = (String)this.get("namespace", "");
        this.put("namespace", namespace);
        this.put("actionNames", this.getActionNames(namespace));
        return this.forward(this.forward$default$1());
    }

    public View action() {
        String actionName = (String)this.get("name", "");
        ActionMapping mapping = (ActionMapping)this.configurer().getActionMapping(actionName).get();
        try {
            Class clazz = mapping.clazz();
            this.put("properties", BeanInfos$.MODULE$.get(clazz).properties().values().filterNot((Function1 & Serializable)m -> m.name().contains("$")));
        }
        catch (Throwable e) {
            Logger$.MODULE$.error$extension(this.logger(), () -> MvcAction.action$$anonfun$2(actionName), () -> MvcAction.action$$anonfun$3(e));
            this.addError("Unable to retrieve action properties: " + e.toString(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        this.put("mapping", mapping);
        this.put("mappings", mapping.mappings());
        return this.forward(this.forward$default$1());
    }

    public View jekyll() {
        String packageName = (String)this.get("packageName", "");
        HashSet actionNames = new HashSet();
        Set configs = this.configurer().actionMappings().values().toSet();
        HashMap descriptions = new HashMap();
        Messages messages = Messages$.MODULE$.apply(Locale.SIMPLIFIED_CHINESE);
        HashMap configMap = new HashMap();
        configs.foreach((Function1)(JProcedure1 & Serializable)config -> {
            if (config.clazz().getName().startsWith(packageName)) {
                String actionName = config.name();
                actionNames.$plus$eq((Object)actionName);
                descriptions.put((Object)actionName, (Object)messages.get(config.clazz(), "class"));
                configMap.put((Object)actionName, config);
                return;
            }
        });
        this.put("messages", messages);
        this.put("configMap", configMap);
        this.put("actionNames", actionNames.toList().sorted((Ordering)Ordering.String$.MODULE$));
        this.put("descriptions", descriptions);
        return this.forward(this.forward$default$1());
    }

    private Seq<String> getNamespaces() {
        Set configs = this.configurer().actionMappings().values().toSet();
        return (Seq)((IterableOnceOps)configs.map((Function1 & Serializable)config -> config.namespace())).toList().sorted((Ordering)Ordering.String$.MODULE$);
    }

    private Seq<String> getActionNames(String namespace) {
        HashSet actionNames = new HashSet();
        Set configs = this.configurer().actionMappings().values().toSet();
        configs.foreach((Function1)(JProcedure1 & Serializable)config -> {
            String string = config.namespace();
            String string2 = namespace;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = config.name();
                String string4 = namespace;
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    actionNames.$plus$eq((Object)"");
                    return;
                }
                actionNames.$plus$eq((Object)Strings$.MODULE$.substringAfter(config.name(), namespace + "/"));
                return;
            }
        });
        return (Seq)actionNames.toList().sorted((Ordering)Ordering.String$.MODULE$);
    }

    private static final String action$$anonfun$2(String actionName$1) {
        return "Unable to get properties for action " + actionName$1;
    }

    private static final Throwable action$$anonfun$3(Throwable e$1) {
        return e$1;
    }
}

