/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.webmvc.showcase.action.config.hibernate;

import java.util.Date;
import org.beangle.commons.lang.annotation.description;
import org.beangle.web.action.annotation.action;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.showcase.action.config.hibernate.AbstractAction;
import org.hibernate.SessionFactory;
import org.hibernate.stat.Statistics;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@action(value="stat/{session_factory_id}")
@description(value="Hibernate\u8fd0\u884c/\u7f13\u5b58\u7edf\u8ba1\u67e5\u770b\u5668")
public class StatAction
extends AbstractAction {
    private Date activation = null;
    private Date deactivation = null;

    public Date activation() {
        return this.activation;
    }

    public void activation_$eq(Date x$1) {
        this.activation = x$1;
    }

    public Date deactivation() {
        return this.deactivation;
    }

    public void deactivation_$eq(Date x$1) {
        this.deactivation = x$1;
    }

    public View index() {
        boolean active;
        SessionFactory sessionFactory = this.getSessionFactory();
        Statistics statistics = sessionFactory.getStatistics();
        Date lastUpdate = new Date();
        ListBuffer generalStatistics = new ListBuffer();
        String action2 = (String)this.get("do", "");
        StringBuilder info = new StringBuilder(512);
        if ("activate".equals(action2) && !statistics.isStatisticsEnabled()) {
            statistics.setStatisticsEnabled(true);
            this.activation_$eq(new Date());
            this.deactivation_$eq(null);
            info.append("Statistics enabled\n");
        } else if ("deactivate".equals(action2) && statistics.isStatisticsEnabled()) {
            statistics.setStatisticsEnabled(false);
            this.deactivation_$eq(new Date());
            info.append("Statistics disabled\n");
        } else if ("clear".equals(action2)) {
            this.activation_$eq(null);
            this.deactivation_$eq(null);
            statistics.clear();
            generalStatistics.clear();
            info.append("Statistics cleared\n");
        }
        if (info.length() > 0) {
            this.addMessage(info.toString(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        if (active = statistics.isStatisticsEnabled()) {
            generalStatistics.$plus$eq((Object)BoxesRunTime.boxToLong((long)statistics.getConnectCount()));
            generalStatistics.$plus$eq((Object)BoxesRunTime.boxToLong((long)statistics.getFlushCount()));
            generalStatistics.$plus$eq((Object)BoxesRunTime.boxToLong((long)statistics.getPrepareStatementCount()));
            generalStatistics.$plus$eq((Object)BoxesRunTime.boxToLong((long)statistics.getCloseStatementCount()));
            generalStatistics.$plus$eq((Object)BoxesRunTime.boxToLong((long)statistics.getSessionCloseCount()));
            generalStatistics.$plus$eq((Object)BoxesRunTime.boxToLong((long)statistics.getSessionOpenCount()));
            generalStatistics.$plus$eq((Object)BoxesRunTime.boxToLong((long)statistics.getTransactionCount()));
            generalStatistics.$plus$eq((Object)BoxesRunTime.boxToLong((long)statistics.getSuccessfulTransactionCount()));
            generalStatistics.$plus$eq((Object)BoxesRunTime.boxToLong((long)statistics.getOptimisticFailureCount()));
        }
        this.put("active", BoxesRunTime.boxToBoolean((boolean)active));
        this.put("lastUpdate", lastUpdate);
        if (this.activation() != null) {
            if (this.deactivation() != null) {
                this.put("duration", BoxesRunTime.boxToLong((long)(this.deactivation().getTime() - this.activation().getTime())));
            } else {
                this.put("duration", BoxesRunTime.boxToLong((long)(lastUpdate.getTime() - this.activation().getTime())));
            }
        }
        this.put("activation", this.activation());
        this.put("deactivation", this.deactivation());
        this.put("generalStatistics", generalStatistics);
        this.put("statistics", statistics);
        return this.forward(this.forward$default$1());
    }

    public View entity() {
        Statistics statistics = this.getSessionFactory().getStatistics();
        this.put("statistics", statistics);
        return this.forward(this.forward$default$1());
    }

    public View query() {
        Statistics statistics = this.getSessionFactory().getStatistics();
        this.put("statistics", statistics);
        return this.forward("queryCache");
    }

    public View collection() {
        Statistics statistics = this.getSessionFactory().getStatistics();
        this.put("statistics", statistics);
        return this.forward(this.forward$default$1());
    }

    public View cache() {
        Statistics statistics = this.getSessionFactory().getStatistics();
        this.put("statistics", statistics);
        return this.forward(this.forward$default$1());
    }
}

