/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.webmvc.support.action;

import java.time.Instant;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.text.inflector.en.EnNounPluralizer$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.data.model.meta.EntityType;
import org.beangle.data.model.pojo.Updated;
import org.beangle.web.action.annotation.ignore;
import org.beangle.web.action.annotation.mapping;
import org.beangle.web.action.annotation.param;
import org.beangle.web.action.context.ActionContext$;
import org.beangle.web.action.context.Params$;
import org.beangle.web.action.support.ActionSupport;
import org.beangle.web.action.support.EntitySupport;
import org.beangle.web.action.view.View;
import org.beangle.webmvc.config.RouteMapping;
import org.beangle.webmvc.execution.MappingHandler;
import org.beangle.webmvc.support.action.EntityAction;
import org.beangle.webmvc.support.helper.PopulateHelper$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class RestfulAction<T extends Entity<?>>
extends ActionSupport
implements EntityAction<T> {
    private Class entityClass;
    private EntityDao entityDao;

    public RestfulAction() {
        EntitySupport.$init$((EntitySupport)this);
        Statics.releaseFence();
    }

    public Class entityClass() {
        return this.entityClass;
    }

    public void org$beangle$web$action$support$EntitySupport$_setter_$entityClass_$eq(Class x$0) {
        this.entityClass = x$0;
    }

    @Override
    public EntityDao entityDao() {
        return this.entityDao;
    }

    public void entityDao_$eq(EntityDao x$1) {
        this.entityDao = x$1;
    }

    public View index() {
        this.indexSetting();
        return this.forward(this.forward$default$1());
    }

    public View search() {
        this.put(EnNounPluralizer$.MODULE$.pluralize(this.simpleEntityName()), this.entityDao().search((QueryBuilder)this.getQueryBuilder()));
        return this.forward(this.forward$default$1());
    }

    @mapping(value="{id}")
    public View info(@param(value="id") String id) {
        EntityType entityType = (EntityType)this.entityDao().domain().getEntity(this.entityClass()).get();
        this.put(this.simpleEntityName(), this.getModel(entityType, this.convertId(entityType, id)));
        return this.forward(this.forward$default$1());
    }

    public void indexSetting() {
    }

    @mapping(value="{id}/edit")
    public View edit(@param(value="id") String id) {
        Entity entity = this.getModel(id);
        this.editSetting(entity);
        this.put(this.simpleEntityName(), entity);
        return this.forward(this.forward$default$1());
    }

    @mapping(value="new", view="new,form")
    public View editNew() {
        Entity entity = (Entity)this.getEntity(this.entityClass(), this.simpleEntityName());
        this.editSetting(entity);
        this.put(this.simpleEntityName(), entity);
        return this.forward(this.forward$default$1());
    }

    @mapping(method="delete")
    public View remove() {
        View view;
        Seq seq;
        EntityType entityType = (EntityType)this.entityDao().domain().getEntity(this.entityClass()).get();
        Class idclass = entityType.id().clazz();
        Option option = Params$.MODULE$.getId(this.simpleEntityName(), idclass);
        if (option instanceof Some) {
            Object entityId = ((Some)option).value();
            seq = (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Entity[]{(Entity)this.getModel(entityType, entityId)}));
        } else if (None$.MODULE$.equals(option)) {
            seq = this.getModels(entityType, (Iterable)Params$.MODULE$.getIds(this.simpleEntityName(), idclass));
        } else {
            throw new MatchError((Object)option);
        }
        Seq entities = seq;
        try {
            view = this.removeAndRedirect(entities);
        }
        catch (Exception e) {
            Logger$.MODULE$.info$extension(this.logger(), RestfulAction::remove$$anonfun$1, () -> RestfulAction.remove$$anonfun$2(e));
            view = this.redirect("search", "info.delete.failure");
        }
        return view;
    }

    @mapping(value="{id}", method="put")
    public View update(@param(value="id") String id) {
        Entity entity = PopulateHelper$.MODULE$.populate(this.getModel(id), (EntityType)this.entityDao().domain().getEntity(this.entityClass()).get(), this.simpleEntityName());
        return this.persist(entity);
    }

    @mapping(method="post")
    public View save() {
        return this.persist(this.populateEntity());
    }

    @ignore
    public View saveAndRedirect(T entity) {
        this.saveOrUpdate(entity);
        return this.redirect("search", "info.save.success");
    }

    @ignore
    public View removeAndRedirect(Seq<T> entities) {
        this.remove((Seq)entities);
        return this.redirect("search", "info.remove.success");
    }

    public void editSetting(T entity) {
    }

    private View persist(T entity) {
        View view;
        try {
            T t = entity;
            if (t instanceof Updated) {
                Entity updated = (Entity)((Updated)t);
                ((Updated)updated).updatedAt_$eq(Instant.now());
            }
            view = this.saveAndRedirect(entity);
        }
        catch (Exception e) {
            String string;
            RouteMapping mapping2 = ((MappingHandler)ActionContext$.MODULE$.current().handler()).mapping();
            String string2 = mapping2.method().getName();
            if ("save".equals(string2)) {
                string = "editNew";
            } else if ("update".equals(string2)) {
                string = "edit";
            } else {
                throw new MatchError((Object)string2);
            }
            String redirectTo = string;
            Logger$.MODULE$.info$extension(this.logger(), RestfulAction::persist$$anonfun$1, () -> RestfulAction.persist$$anonfun$2(e));
            view = this.redirect(redirectTo, "info.save.failure");
        }
        return view;
    }

    private static final String remove$$anonfun$1() {
        return "removeAndRedirect failure";
    }

    private static final Throwable remove$$anonfun$2(Exception e$1) {
        return e$1;
    }

    private static final String persist$$anonfun$1() {
        return "saveAndRedirect failure";
    }

    private static final Throwable persist$$anonfun$2(Exception e$2) {
        return e$2;
    }
}

