/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.webmvc.support.helper;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.GregorianCalendar;
import org.beangle.commons.collection.Order$;
import org.beangle.commons.collection.page.Page$;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.lang.Numbers$;
import org.beangle.commons.lang.Strings$;
import org.beangle.commons.lang.reflect.BeanInfos$;
import org.beangle.commons.lang.reflect.Reflections$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.beangle.data.dao.Condition;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.model.Entity;
import org.beangle.data.model.meta.EntityType;
import org.beangle.data.model.meta.Property;
import org.beangle.data.model.meta.SingularProperty;
import org.beangle.web.action.context.ActionContext$;
import org.beangle.web.action.context.Params$;
import org.beangle.web.servlet.util.CookieUtils$;
import org.beangle.webmvc.support.helper.PopulateHelper$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class QueryHelper$
implements Logging,
Serializable {
    private static Logger logger;
    private static final String PageParam;
    private static final String PageSizeParam;
    private static final boolean RESERVED_NULL;
    public static final QueryHelper$ MODULE$;

    private QueryHelper$() {
    }

    static {
        MODULE$ = new QueryHelper$();
        Logging.$init$((Logging)MODULE$);
        PageParam = "pageIndex";
        PageSizeParam = "pageSize";
        RESERVED_NULL = true;
        Set keySeparators = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{',', '\uff0c', ';', '\uff1b'}));
        Statics.releaseFence();
    }

    public Logger logger() {
        return logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(QueryHelper$.class);
    }

    public String PageParam() {
        return PageParam;
    }

    public String PageSizeParam() {
        return PageSizeParam;
    }

    public boolean RESERVED_NULL() {
        return RESERVED_NULL;
    }

    public QueryHelper$ populateConditions(OqlBuilder<?> builder) {
        builder.where(this.extractConditions(builder.entityClass(), builder.alias(), null));
        return this;
    }

    public QueryHelper$ populate(OqlBuilder<?> entityQuery, String exclusiveAttrNames) {
        entityQuery.where(this.extractConditions(entityQuery.entityClass(), entityQuery.alias(), exclusiveAttrNames));
        return this;
    }

    public List<Condition> extractConditions(Class<?> clazz, String prefix, String exclusiveAttrNames) {
        Entity entity = null;
        Class newClazz = clazz;
        EntityType entityType = PopulateHelper$.MODULE$.getType(clazz);
        try {
            if (clazz.isInterface()) {
                newClazz = entityType.clazz();
            }
            entity = (Entity)Reflections$.MODULE$.newInstance(clazz);
        }
        catch (Exception exception) {
            throw new RuntimeException("[RequestUtil.extractConditions]: error in in initialize " + clazz);
        }
        ListBuffer conditions = new ListBuffer();
        Map params = Params$.MODULE$.sub(prefix, exclusiveAttrNames);
        for (Tuple2 entry : params) {
            String attr = (String)entry._1();
            Object value = entry._2();
            String strValue = value.toString().trim();
            if (!Strings$.MODULE$.isNotEmpty((CharSequence)strValue)) continue;
            try {
                List values;
                if (this.RESERVED_NULL() && "null".equals(strValue)) {
                    conditions.$plus$eq((Object)new Condition(prefix + "." + attr + " is null", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
                    continue;
                }
                Tuple2 vt = PopulateHelper$.MODULE$.populator().init(entity, entityType, attr);
                if (vt == null || !(vt._2() instanceof SingularProperty) || !(values = this.getAll((Map<String, Object>)params, attr, ((Property)vt._2()).clazz())).nonEmpty()) continue;
                Class clazz2 = ((Property)vt._2()).clazz();
                Class<String> clazz3 = String.class;
                if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                    String head = values.head().toString();
                    if (values.size() == 1 && StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(head), ',')) {
                        values = Predef$.MODULE$.wrapRefArray((Object[])Strings$.MODULE$.split(head, ',')).toList();
                        head = values.head().toString();
                    }
                    if (values.size() == 1) {
                        conditions.$plus$eq((Object)new Condition(prefix + "." + attr + " like :" + attr.replace('.', '_'), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"%" + head + "%"})));
                        continue;
                    }
                    String orQuery = values.indices().map((Function1 & Serializable)i -> this.$anonfun$1(prefix, attr, BoxesRunTime.unboxToInt((Object)i))).mkString(" or ");
                    List newValues = values.map((Function1 & Serializable)x -> "%" + x + "%");
                    conditions.$plus$eq((Object)new Condition(orQuery, (Seq)newValues));
                    continue;
                }
                if (values.size() == 1) {
                    conditions.$plus$eq((Object)new Condition(prefix + "." + attr + " =:" + attr.replace('.', '_'), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{values.head()})));
                    continue;
                }
                conditions.$plus$eq((Object)new Condition(prefix + "." + attr + " in (:" + attr.replace('.', '_') + ")", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{values})));
            }
            catch (Exception e) {
                Logger$.MODULE$.error$extension(this.logger(), () -> this.extractConditions$$anonfun$1(prefix, attr), () -> this.extractConditions$$anonfun$2(e));
            }
        }
        return conditions.toList();
    }

    private List<Object> getAll(Map<String, Object> params, String attr) {
        Option option = params.get((Object)attr);
        if (option instanceof Some) {
            Object value = ((Some)option).value();
            if (value == null) {
                return package$.MODULE$.List().empty();
            }
            if (value.getClass().isArray()) {
                return Predef$.MODULE$.genericWrapArray((Object)((Object[])value)).toList();
            }
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{value}));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        throw new MatchError((Object)option);
    }

    private <T> List<T> getAll(Map<String, Object> params, String attr, Class<T> clazz) {
        List<Object> value = this.getAll(params, attr);
        if (value.isEmpty()) {
            return package$.MODULE$.List().empty();
        }
        return value.flatMap((Function1 & Serializable)x -> Params$.MODULE$.converter().convert(x, clazz));
    }

    public QueryHelper$ populate(OqlBuilder<?> builder) {
        builder.where(this.extractConditions(builder.entityClass(), builder.alias(), null));
        return this;
    }

    public PageLimit pageLimit() {
        return new PageLimit(this.pageIndex(), this.pageSize());
    }

    public int pageIndex() {
        int n;
        Option option = Params$.MODULE$.getInt(this.PageParam());
        if (option instanceof Some) {
            int p;
            n = p = BoxesRunTime.unboxToInt((Object)((Some)option).value());
        } else if (None$.MODULE$.equals(option)) {
            n = BoxesRunTime.unboxToInt((Object)Params$.MODULE$.getInt("page[number]").getOrElse(this::$anonfun$3));
        } else {
            throw new MatchError((Object)option);
        }
        int pageIndex = n;
        if (pageIndex < 1) {
            return Page$.MODULE$.DefaultPageNo();
        }
        return pageIndex;
    }

    public int pageSize() {
        String pageSize = (String)Params$.MODULE$.get(this.PageSizeParam()).orElse(this::$anonfun$4).getOrElse(this::$anonfun$5);
        int pagesize = Page$.MODULE$.DefaultPageSize();
        if (Strings$.MODULE$.isNotBlank((CharSequence)pageSize)) {
            pagesize = Numbers$.MODULE$.toInt(pageSize.trim(), Numbers$.MODULE$.toInt$default$2());
        } else {
            pageSize = CookieUtils$.MODULE$.getCookieValue(ActionContext$.MODULE$.current().request(), this.PageSizeParam());
            if (Strings$.MODULE$.isNotEmpty((CharSequence)pageSize)) {
                pagesize = Numbers$.MODULE$.toInt(pageSize, Numbers$.MODULE$.toInt$default$2());
            }
        }
        if (pagesize < 1) {
            return Page$.MODULE$.DefaultPageSize();
        }
        return pagesize;
    }

    public QueryHelper$ sort(OqlBuilder<?> query) {
        Some some;
        Option option = Params$.MODULE$.get(Order$.MODULE$.OrderStr());
        if (option instanceof Some) {
            Some orderBy;
            some = orderBy = (Some)option;
        } else if (None$.MODULE$.equals(option)) {
            some = Params$.MODULE$.get("sort");
        } else {
            throw new MatchError((Object)option);
        }
        Some sort = some;
        sort.foreach((Function1 & Serializable)orderClause -> (OqlBuilder)query.orderBy(orderClause));
        return this;
    }

    public QueryHelper$ limit(OqlBuilder<?> query) {
        query.limit(this.pageIndex(), this.pageSize());
        return this;
    }

    public void addDateIntervalCondition(OqlBuilder<?> query, String attr, String beginOnName, String endOnName) {
        this.dateBetween(query, query.alias(), attr, beginOnName, endOnName);
    }

    public void addDateIntervalCondition(OqlBuilder<?> query, String alias, String attr, String beginOnName, String endOnName) {
        this.dateBetween(query, alias, attr, beginOnName, endOnName);
    }

    public void dateBetween(OqlBuilder<?> query, String alias, String attr, String beginOnName, String endOnName) {
        None$ edate;
        None$ none$;
        None$ sdate;
        Option stime = Params$.MODULE$.get(beginOnName);
        Option etime = Params$.MODULE$.get(endOnName);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (stime.isDefined()) {
            try {
                v0 = Some$.MODULE$.apply((Object)df.parse((String)stime.get()));
            }
            catch (ParseException parseException) {
                v0 = None$.MODULE$;
            }
        } else {
            v0 = sdate = None$.MODULE$;
        }
        if (etime.isDefined()) {
            try {
                none$ = Some$.MODULE$.apply((Object)df.parse((String)etime.get()));
            }
            catch (ParseException parseException) {
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        if ((edate = none$).isDefined()) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime((Date)edate.get());
            gc.set(6, gc.get(6) + 1);
            edate = Some$.MODULE$.apply((Object)gc.getTime());
        }
        String objAttr = (alias == null ? query.alias() : alias) + "." + attr;
        if (query.entityClass() != null) {
            Option option = BeanInfos$.MODULE$.get(query.entityClass()).getPropertyType(attr);
            if (option instanceof Some) {
                Class pc = (Class)((Some)option).value();
                if (LocalDateTime.class.isAssignableFrom(pc)) {
                    Option start = sdate.map((Function1 & Serializable)x -> LocalDateTime.ofInstant(x.toInstant(), ZoneId.systemDefault()));
                    Option end = edate.map((Function1 & Serializable)x -> LocalDateTime.ofInstant(x.toInstant(), ZoneId.systemDefault()));
                    this.between(query, objAttr, (Option<Object>)start, (Option<Object>)end);
                    return;
                }
                if (Instant.class.isAssignableFrom(pc)) {
                    this.between(query, objAttr, (Option<Object>)sdate.map((Function1 & Serializable)_$1 -> _$1.toInstant()), (Option<Object>)edate.map((Function1 & Serializable)_$2 -> _$2.toInstant()));
                    return;
                }
                if (LocalDate.class.isAssignableFrom(pc)) {
                    Option start = sdate.map((Function1 & Serializable)x -> LocalDate.ofInstant(x.toInstant(), ZoneId.systemDefault()));
                    Option end = edate.map((Function1 & Serializable)x -> LocalDate.ofInstant(x.toInstant(), ZoneId.systemDefault()));
                    this.between(query, objAttr, (Option<Object>)start, (Option<Object>)end);
                    return;
                }
                this.between(query, objAttr, (Option<Object>)sdate, (Option<Object>)edate);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.between(query, objAttr, (Option<Object>)sdate, (Option<Object>)edate);
                return;
            }
            throw new MatchError((Object)option);
        }
    }

    private void between(OqlBuilder<?> query, String path, Option<Object> sdate, Option<Object> edate) {
        if (sdate.isDefined() && edate.isEmpty()) {
            OqlBuilder cfr_ignored_0 = (OqlBuilder)query.where(path + " >=:sdate", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{sdate.get()}));
            return;
        }
        if (sdate.isDefined() && edate.isDefined()) {
            OqlBuilder cfr_ignored_1 = (OqlBuilder)query.where(path + " >=:sdate and " + path + " <:edate", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{sdate.get(), edate.get()}));
            return;
        }
        if (sdate.isEmpty() && edate.isDefined()) {
            OqlBuilder cfr_ignored_2 = (OqlBuilder)query.where(path + " <:edate", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{edate.get()}));
            return;
        }
    }

    private final /* synthetic */ String $anonfun$1(String prefix$1, String attr$1, int i) {
        return prefix$1 + "." + attr$1 + " like :" + attr$1.replace('.', '_') + "_" + i;
    }

    private final String extractConditions$$anonfun$1(String prefix$2, String attr$2) {
        return "Error populate entity " + prefix$2 + "'s attribute " + attr$2;
    }

    private final Throwable extractConditions$$anonfun$2(Exception e$1) {
        return e$1;
    }

    private final int $anonfun$3() {
        return Page$.MODULE$.DefaultPageNo();
    }

    private final Option $anonfun$4() {
        return Params$.MODULE$.get("page[size]");
    }

    private final String $anonfun$5() {
        return "";
    }
}

