/*
 * Beangle, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2005-2015, Beangle Software.
 *
 * Beangle is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Beangle is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Beangle.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.beangle.webmvc.view.freemarker

import freemarker.template.{ ObjectWrapper, TemplateHashModel, TemplateModel }
import javax.servlet.ServletContext

/**
 * Just replace freemarker ServletContextHashModel
 */
class ServletContextHashModel(context: ServletContext, wrapper: ObjectWrapper) extends TemplateHashModel {

  override def get(key: String): TemplateModel = {
    wrapper.wrap(context.getAttribute(key))
  }

  override def isEmpty: Boolean = {
    context.getAttributeNames.hasMoreElements
  }

}
