/*
 * Beangle, Agile Development Scaffold and Toolkit
 *
 * Copyright (c) 2005-2015, Beangle Software.
 *
 * Beangle is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Beangle is distributed in the hope that it will be useful.
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Beangle.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.beangle.webmvc.view.tag

import java.io.StringWriter
import java.{ util => ju }

import org.beangle.commons.collection.page.Page
import org.beangle.webmvc.api.context.ActionContextHolder
import org.beangle.webmvc.execution.ActionHandler
import org.beangle.webmvc.view.UITheme

import _root_.freemarker.template.utility.StringUtil
import javax.servlet.http.HttpServletRequest

class CoreModels(context: ComponentContext, request: HttpServletRequest) extends AbstractModels(context, request) {

  val textProvider = ActionContextHolder.context.textProvider.get

  def url(url: String) = {
    context.uriRender.render(ActionHandler.mapping, url)
  }

  def now = new ju.Date

  val uitheme = {
    val base = request.getContextPath
    val location = if (base.length() < 2) "/static/themes/"
    else base + "/static/themes/"
    new UITheme(location)
  }

  /**
   * query string and form control
   */
  def paramstring: String = {
    val sw = new StringWriter()
    val em = request.getParameterNames()
    while (em.hasMoreElements()) {
      val attr = em.nextElement()
      val value = request.getParameter(attr)
      if (!attr.equals("x-requested-with")) {
        sw.write(attr)
        sw.write('=')
        sw.write(StringUtil.javaScriptStringEnc(value))
        if (em.hasMoreElements()) sw.write('&')
      }
    }
    return sw.toString()
  }

  def isPage(data: Object) = data.isInstanceOf[Page[_]]

  def text(name: String): String = {
    textProvider(name, name)
  }

  def text(name: String, arg0: Object): String = {
    textProvider(name, name, arg0)
  }

  def text(name: String, arg0: Object, arg1: Object): String = {
    textProvider(name, name, arg0, arg1)
  }

}