/*
 * Copyright (C) 2005, The Beangle Software.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.beangle.webmvc.execution

import jakarta.servlet.http.HttpServletRequest
import org.beangle.cache.{Cache, CacheManager}
import org.beangle.commons.bean.Initializing
import org.beangle.web.servlet.url.UrlBuilder
import org.beangle.web.action.execution.CacheResult

trait ResponseCache{
  def put(request: HttpServletRequest, contentType: String, data: Array[Byte]): Unit

  def get(request: HttpServletRequest): Option[CacheResult]
}

object EmptyResponseCache extends ResponseCache{
  def put(request: HttpServletRequest, contentType: String, data: Array[Byte]): Unit={
  }

  def get(request: HttpServletRequest): Option[CacheResult]={
    None
  }
}

class DefaultResponseCache(cache:Cache[String, CacheResult]) extends ResponseCache {

  override def put(request: HttpServletRequest, contentType: String, data: Array[Byte]): Unit = {
    cache.put(UrlBuilder(request).buildRequestUrl(), CacheResult(contentType, data))
  }

  override def get(request: HttpServletRequest): Option[CacheResult] = {
    cache.get(UrlBuilder(request).buildRequestUrl())
  }
}
