/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch;

import java.util.HashMap;
import java.util.Map;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.wsmessages.SynchEndType;

public class CallbackRegistry {
    private Map<String, CallbackRegistryEntry> theMap = new HashMap<String, CallbackRegistryEntry>();

    public CallbackRegistryEntry get(String connectorId) {
        return this.theMap.get(connectorId);
    }

    public synchronized void put(String connectorId, CallbackRegistryEntry val) throws SynchException {
        CallbackRegistryEntry tblVal = this.get(connectorId);
        if (tblVal != null) {
            throw new SynchException("Entry already in registry. Tried to add" + val + " found " + tblVal);
        }
        this.put(connectorId, val);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("{");
        sb.append("theMap = ");
        sb.append(this.theMap);
        sb.append("}");
        return sb.toString();
    }

    public static class CallbackRegistryEntry {
        private String connectorId;
        private Subscription sub;
        private SynchEndType end;

        public CallbackRegistryEntry(String connectorId, Subscription sub, SynchEndType end) {
            this.connectorId = connectorId;
            this.sub = sub;
            this.end = end;
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public Subscription getSub() {
            return this.sub;
        }

        public SynchEndType getEnd() {
            return this.end;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("CallbackRegistryEntry{");
            sb.append("connectorId=");
            sb.append(this.getConnectorId());
            sb.append("sub=");
            sb.append(this.getSub());
            sb.append(", end=");
            sb.append(this.getEnd());
            sb.append("}");
            return sb.toString();
        }
    }
}

