/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch;

import java.util.ArrayList;
import java.util.List;
import org.bedework.synch.db.SerializablePropertiesImpl;
import org.bedework.synch.filters.DefaultFilter;
import org.bedework.synch.filters.XCategoryFilter;
import org.bedework.synch.filters.XlocXContactFilter;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.SubscriptionConnectorInfo;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.shared.filters.AbstractFilter;
import org.bedework.synch.shared.filters.Filter;
import org.bedework.util.misc.ToString;

public class SubscriptionConnectorInfoImpl
extends SerializablePropertiesImpl<SubscriptionConnectorInfoImpl>
implements SubscriptionConnectorInfo<SubscriptionConnectorInfoImpl> {
    private String connectorId;

    public void setConnectorId(String val) {
        this.connectorId = val;
    }

    public List<Filter> getInputFilters(Subscription sub) throws SynchException {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        AbstractFilter f = new DefaultFilter();
        f.init(sub);
        filters.add((Filter)f);
        if (sub.getInfo().getXlocXcontact()) {
            f = new XlocXContactFilter();
            f.init(sub);
            filters.add((Filter)f);
        }
        if (sub.getInfo().getXlocXcategories()) {
            f = new XCategoryFilter();
            f.init(sub);
            filters.add((Filter)f);
        }
        return filters;
    }

    public List<Filter> getOutputFilters(Subscription sub) throws SynchException {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        AbstractFilter f = new DefaultFilter();
        f.init(sub);
        filters.add((Filter)f);
        if (sub.getInfo().getXlocXcontact()) {
            f = new XlocXContactFilter();
            f.init(sub);
            filters.add((Filter)f);
        }
        if (sub.getInfo().getXlocXcategories()) {
            f = new XCategoryFilter();
            f.init(sub);
            filters.add((Filter)f);
        }
        return filters;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    @Override
    public int hashCode() {
        try {
            return this.getConnectorId().hashCode() * super.hashCode();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public int compareTo(SubscriptionConnectorInfoImpl that) {
        if (this == that) {
            return 0;
        }
        try {
            int res = this.getConnectorId().compareTo(that.getConnectorId());
            if (res != 0) {
                return res;
            }
            return this.doCompare(that);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public String toString() {
        try {
            ToString ts = new ToString((Object)this);
            ts.append("connectorId", (Object)this.getConnectorId());
            super.toStringSegment(ts);
            return ts.toString();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

