/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import net.fortuna.ical4j.model.TimeZone;
import org.bedework.synch.SynchTimer;
import org.bedework.synch.Synchling;
import org.bedework.synch.SynchlingPool;
import org.bedework.synch.conf.SynchConfig;
import org.bedework.synch.db.SynchDb;
import org.bedework.synch.shared.Notification;
import org.bedework.synch.shared.Stat;
import org.bedework.synch.shared.StatLong;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.SynchEngine;
import org.bedework.synch.shared.cnctrs.Connector;
import org.bedework.synch.shared.cnctrs.ConnectorInstance;
import org.bedework.synch.shared.conf.ConnectorConfig;
import org.bedework.synch.shared.conf.ConnectorConfigI;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.shared.service.SynchConnConf;
import org.bedework.synch.wsmessages.SynchEndType;
import org.bedework.util.calendar.XcalUtil;
import org.bedework.util.jmx.ConfigHolder;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.Util;
import org.bedework.util.security.PwEncryptionIntf;
import org.bedework.util.timezones.Timezones;
import org.bedework.util.timezones.TimezonesImpl;
import org.oasis_open.docs.ws_calendar.ns.soap.StatusType;

public class SynchEngineImpl
implements Logged,
SynchEngine,
XcalUtil.TzGetter {
    static ConfigHolder<SynchConfig> cfgHolder;
    private transient PwEncryptionIntf pwEncrypt;
    private final Map<String, Subscription> activeSubs = new HashMap<String, Subscription>();
    private boolean starting;
    private boolean running;
    private boolean stopping;
    private static Object getSyncherLock;
    private static SynchEngine syncher;
    private Timezones timezones;
    static XcalUtil.TzGetter tzgetter;
    private SynchlingPool synchlingPool;
    private SynchTimer synchTimer;
    private BlockingQueue<Notification> notificationInQueue;
    private List<Subscription> subsList;
    private SynchDb db;
    private Map<String, Connector> connectorMap = new HashMap<String, Connector>();
    private StatLong notificationsCt = new StatLong("notifications");
    private StatLong notificationsAddWt = new StatLong("notifications add wait");
    private static NotificationInThread notifyInHandler;
    private BwLogger logger = new BwLogger();

    private SynchEngineImpl() throws SynchException {
        System.setProperty("com.sun.xml.ws.transport.http.client.HttpTransportPipe.dump", String.valueOf(this.debug()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SynchEngine getSyncher() throws SynchException {
        if (syncher != null) {
            return syncher;
        }
        Object object = getSyncherLock;
        synchronized (object) {
            if (syncher != null) {
                return syncher;
            }
            syncher = new SynchEngineImpl();
            return syncher;
        }
    }

    public Timezones getTimezones() {
        return this.timezones;
    }

    public boolean subscriptionsOnly() {
        return SynchEngineImpl.getConfig().getSubscriptionsOnly();
    }

    public void handleNotification(Notification note) {
        try {
            do {
                if (!this.stopping) continue;
                return;
            } while (!this.notificationInQueue.offer(note, 5L, TimeUnit.SECONDS));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setConnectors(Subscription sub) throws SynchException {
        String connectorId = sub.getEndAConnectorInfo().getConnectorId();
        Connector conn = this.getConnector(connectorId);
        if (conn == null) {
            throw new SynchException("No connector for " + sub + "(" + SynchEndType.A + ")");
        }
        sub.setEndAConn(conn);
        connectorId = sub.getEndBConnectorInfo().getConnectorId();
        conn = this.getConnector(connectorId);
        if (conn == null) {
            throw new SynchException("No connector for " + sub + "(" + SynchEndType.B + ")");
        }
        sub.setEndBConn(conn);
    }

    public void rescheduleNow(String id) throws SynchException {
        Subscription sub;
        if (this.debug()) {
            this.debug("reschedule now for subscription id " + id);
        }
        if ((sub = this.getSubscription(id)) == null && this.debug()) {
            this.debug("No subscription");
            return;
        }
        this.setConnectors(sub);
        sub.setErrorCt(0);
        this.synchTimer.schedule(sub, new Date());
    }

    public void reschedule(Subscription sub, boolean newSub) {
        if (this.debug()) {
            this.debug("reschedule subscription " + sub);
        }
        if (sub.polling()) {
            Date when = null;
            try {
                when = sub.nextRefresh();
            }
            catch (Throwable t) {
                this.error(t);
            }
            this.synchTimer.schedule(sub, when);
            return;
        }
        this.activeSubs.put(sub.getSubscriptionId(), sub);
    }

    public ConnectorInstance getConnectorInstance(Subscription sub, SynchEndType end) throws SynchException {
        Connector conn;
        ConnectorInstance cinst;
        if (end == SynchEndType.A) {
            cinst = sub.getEndAConnInst();
            conn = sub.getEndAConn();
        } else {
            cinst = sub.getEndBConnInst();
            conn = sub.getEndBConn();
        }
        if (cinst != null) {
            return cinst;
        }
        if (conn == null) {
            throw new SynchException("No connector for " + sub + "(" + end + ")");
        }
        cinst = conn.getConnectorInstance(sub, end);
        if (cinst == null) {
            throw new SynchException("No connector instance for " + sub + "(" + end + ")");
        }
        if (end == SynchEndType.A) {
            sub.setEndAConnInst(cinst);
        } else {
            sub.setEndBConnInst(cinst);
        }
        return cinst;
    }

    public void addSubscription(Subscription sub) throws SynchException {
        this.db.add(sub);
        sub.resetChanged();
    }

    public void deleteSubscription(Subscription sub) throws SynchException {
        this.db.delete(sub);
    }

    public void updateSubscription(Subscription sub) throws SynchException {
        boolean opened = this.db.open();
        try {
            this.db.update(sub);
            sub.resetChanged();
        }
        finally {
            if (opened) {
                this.db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription getSubscription(String id) throws SynchException {
        boolean opened = this.db.open();
        try {
            Subscription subscription = this.db.get(id);
            return subscription;
        }
        finally {
            if (opened) {
                this.db.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription find(Subscription sub) throws SynchException {
        boolean opened = this.db.open();
        try {
            Subscription subscription = this.db.find(sub);
            return subscription;
        }
        finally {
            if (opened) {
                this.db.close();
            }
        }
    }

    public Connector getConnector(String id) {
        return this.connectorMap.get(id);
    }

    public Set<String> getConnectorIds() {
        return this.connectorMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotifications(Connector.NotificationBatch<Notification> notes) throws SynchException {
        for (Notification note : notes.getNotifications()) {
            this.db.open();
            Synchling sl = null;
            try {
                if (note.getSub() == null) continue;
                sl = this.synchlingPool.get();
                this.handleNotification(sl, note);
            }
            finally {
                this.db.close();
                if (sl == null) continue;
                this.synchlingPool.add(sl);
            }
        }
    }

    public XcalUtil.TzGetter getTzGetter() {
        return tzgetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws SynchException {
        try {
            if (this.starting || this.running) {
                this.warn("Start called when already starting or running");
                return;
            }
            SynchEngineImpl synchEngineImpl = this;
            synchronized (synchEngineImpl) {
                this.subsList = null;
                this.starting = true;
            }
            this.db = new SynchDb(SynchEngineImpl.getConfig());
            this.timezones = new TimezonesImpl();
            this.timezones.init(SynchEngineImpl.getConfig().getTimezonesURI());
            tzgetter = this;
            this.synchlingPool = new SynchlingPool();
            this.synchlingPool.start(this, SynchEngineImpl.getConfig().getSynchlingPoolSize(), SynchEngineImpl.getConfig().getSynchlingPoolTimeout());
            this.notificationInQueue = new ArrayBlockingQueue<Notification>(100);
            this.info("**************************************************");
            this.info("Starting synch");
            this.info("      callback URI: " + SynchEngineImpl.getConfig().getCallbackURI());
            this.info("**************************************************");
            if (SynchEngineImpl.getConfig().getKeystore() != null) {
                System.setProperty("javax.net.ssl.trustStore", SynchEngineImpl.getConfig().getKeystore());
                System.setProperty("javax.net.ssl.trustStorePassword", "bedework");
            }
            List<SynchConnConf> connectorConfs = SynchEngineImpl.getConfig().getConnectorConfs();
            String callbackUriBase = SynchEngineImpl.getConfig().getCallbackURI();
            block12: for (SynchConnConf scc : connectorConfs) {
                ConnectorConfig conf = (ConnectorConfig)scc.getConfig();
                String cnctrId = conf.getName();
                this.info("Register and start connector " + cnctrId);
                this.registerConnector(cnctrId, conf);
                Connector conn = this.getConnector(cnctrId);
                scc.setConnector(conn);
                conn.start(cnctrId, (ConnectorConfigI)conf, callbackUriBase + cnctrId + "/", (SynchEngine)this);
                while (!conn.isStarted()) {
                    SynchEngineImpl synchEngineImpl2 = this;
                    synchronized (synchEngineImpl2) {
                        this.wait(250L);
                        if (!conn.isFailed()) continue;
                    }
                    this.error("Connector " + cnctrId + " failed to start");
                    continue block12;
                }
            }
            this.synchTimer = new SynchTimer(this);
            notifyInHandler = new NotificationInThread();
            notifyInHandler.start();
            try {
                this.db.open();
                List<Subscription> startList = this.db.getAll();
                this.db.close();
                while (this.starting) {
                    if (this.debug()) {
                        this.debug("startList has " + startList.size() + " subscriptions");
                    }
                    for (Subscription sub : startList) {
                        this.setConnectors(sub);
                        this.reschedule(sub, false);
                    }
                    SynchEngineImpl synchEngineImpl3 = this;
                    synchronized (synchEngineImpl3) {
                        if (this.subsList == null) {
                            this.starting = false;
                            if (this.stopping) {
                            } else {
                                this.running = true;
                            }
                            break;
                        }
                        startList = this.subsList;
                        this.subsList = null;
                    }
                }
            }
            finally {
                if (this.db != null && this.db.isOpen()) {
                    this.db.close();
                }
            }
            this.info("**************************************************");
            this.info("Synch started");
            this.info("**************************************************");
            return;
        }
        catch (SynchException se) {
            this.error(se);
            this.starting = false;
            this.running = false;
            throw se;
        }
        catch (Throwable t) {
            this.error(t);
            this.starting = false;
            this.running = false;
            throw new SynchException(t);
        }
    }

    public List<Stat> getStats() {
        ArrayList<Stat> stats = new ArrayList<Stat>();
        stats.addAll(this.synchlingPool.getStats());
        stats.addAll(this.synchTimer.getStats());
        stats.add((Stat)this.notificationsCt);
        stats.add((Stat)this.notificationsAddWt);
        return stats;
    }

    public void stop() {
        if (this.stopping) {
            return;
        }
        this.stopping = true;
        for (Connector conn : this.getConnectors()) {
            this.info("Stopping connector " + conn.getId());
            try {
                conn.stop();
            }
            catch (Throwable t) {
                if (this.debug()) {
                    this.error(t);
                    continue;
                }
                this.error(t.getMessage());
            }
        }
        this.info("Connectors stopped");
        if (this.synchlingPool != null) {
            this.synchlingPool.stop();
        }
        syncher = null;
        this.info("**************************************************");
        this.info("Synch shutdown complete");
        this.info("**************************************************");
    }

    public boolean getRunning() {
        return this.running;
    }

    public static void setConfigHolder(ConfigHolder<SynchConfig> val) {
        cfgHolder = val;
    }

    public static SynchConfig getConfig() {
        if (cfgHolder == null) {
            return null;
        }
        return (SynchConfig)cfgHolder.getConfig();
    }

    public void updateConfig() throws SynchException {
        if (cfgHolder != null) {
            cfgHolder.putConfig();
        }
    }

    public TimeZone getTz(String id) throws Throwable {
        return SynchEngineImpl.getSyncher().getTimezones().getTimeZone(id);
    }

    public String decrypt(String val) throws SynchException {
        if (val == null) {
            return null;
        }
        try {
            return this.getEncrypter().decrypt(val);
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    public PwEncryptionIntf getEncrypter() throws SynchException {
        if (this.pwEncrypt != null) {
            return this.pwEncrypt;
        }
        try {
            String pwEncryptClass = "org.bedework.util.security.PwEncryptionDefault";
            this.pwEncrypt = (PwEncryptionIntf)Util.getObject((String)pwEncryptClass, PwEncryptionIntf.class);
            this.pwEncrypt.init(SynchEngineImpl.getConfig().getPrivKeys(), SynchEngineImpl.getConfig().getPubKeys());
            return this.pwEncrypt;
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new SynchException(t);
        }
    }

    private Collection<Connector> getConnectors() {
        return this.connectorMap.values();
    }

    private void registerConnector(String id, ConnectorConfig conf) throws SynchException {
        try {
            Class<?> cl = Class.forName(conf.getConnectorClassName());
            if (this.connectorMap.containsKey(id)) {
                throw new SynchException("Connector " + id + " already registered");
            }
            Connector c = (Connector)cl.newInstance();
            this.connectorMap.put(id, c);
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
    }

    private StatusType handleNotification(Synchling sl, Notification note) throws SynchException {
        StatusType st = sl.handleNotification((Notification<Notification.NotificationItem>)note);
        Subscription sub = note.getSub();
        if (sub.getDeleted() || !sub.getMissingTarget()) {
            return st;
        }
        if (sub.getErrorCt() > SynchEngineImpl.getConfig().getMissingTargetRetries()) {
            this.deleteSubscription(sub);
            this.info("Subscription deleted after missing target retries exhausted: " + sub);
        }
        return st;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    static {
        getSyncherLock = new Object();
    }

    private class NotificationInThread
    extends Thread {
        long lastTrace;

        public NotificationInThread() {
            super("NotifyIn");
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

