/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.bedework.synch.shared.Notification;
import org.bedework.synch.shared.Stat;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.SynchEngine;
import org.bedework.synch.wsmessages.SynchEndType;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;

public class SynchTimer
implements Logged {
    private final SynchEngine syncher;
    Timer timer;
    private final Map<String, SynchTask> waiting = new HashMap<String, SynchTask>();
    private long maxWaitingCt;
    private BwLogger logger = new BwLogger();

    public SynchTimer(SynchEngine syncher) {
        this.syncher = syncher;
        this.timer = new Timer("SynchTimer", true);
    }

    public void stop() {
        if (this.timer == null) {
            return;
        }
        this.timer.cancel();
        this.timer = null;
    }

    public void schedule(Subscription sub, Date when) {
        Date whenToResched = when;
        if (this.debug()) {
            this.debug("reschedule " + sub.getSubscriptionId() + " for " + when);
        }
        if (when == null) {
            whenToResched = new Date(System.currentTimeMillis() + 600000L);
        }
        SynchTask st = new SynchTask(sub);
        this.timer.schedule((TimerTask)st, whenToResched);
    }

    public void schedule(Subscription sub, long delay) {
        SynchTask st = new SynchTask(sub);
        this.timer.schedule((TimerTask)st, delay);
    }

    public long getWaitingCt() {
        return this.waiting.size();
    }

    public long getMaxWaitingCt() {
        return this.maxWaitingCt;
    }

    public List<Stat> getStats() {
        ArrayList<Stat> stats = new ArrayList<Stat>();
        stats.add(new Stat("waiting", this.getWaitingCt()));
        stats.add(new Stat("max waiting", this.getMaxWaitingCt()));
        return stats;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    class SynchTask
    extends TimerTask {
        private final Subscription sub;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SynchTask(Subscription sub) {
            this.sub = sub;
            Map<String, SynchTask> map = SynchTimer.this.waiting;
            synchronized (map) {
                SynchTimer.this.waiting.put(sub.getSubscriptionId(), this);
                SynchTimer.this.maxWaitingCt = Math.max(SynchTimer.this.maxWaitingCt, (long)SynchTimer.this.waiting.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<String, SynchTask> map = SynchTimer.this.waiting;
            synchronized (map) {
                SynchTimer.this.waiting.remove(this.sub.getSubscriptionId());
            }
            if (SynchTimer.this.debug()) {
                SynchTimer.this.debug("About to send resynch notification for " + this.sub.getSubscriptionId());
            }
            Notification.NotificationItem ni = new Notification.NotificationItem(Notification.NotificationItem.ActionType.FullSynch, null, null);
            Notification note = new Notification(this.sub, SynchEndType.NONE, ni);
            SynchTimer.this.syncher.handleNotification(note);
        }
    }
}

