/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch;

import ietf.params.xml.ns.icalendar_2.IcalendarType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.ws.Holder;
import org.bedework.synch.filters.Filters;
import org.bedework.synch.shared.BaseSubscriptionInfo;
import org.bedework.synch.shared.Notification;
import org.bedework.synch.shared.Subscription;
import org.bedework.synch.shared.SubscriptionConnectorInfo;
import org.bedework.synch.shared.SynchEngine;
import org.bedework.synch.shared.cnctrs.Connector;
import org.bedework.synch.shared.cnctrs.ConnectorInstance;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.shared.filters.Filter;
import org.bedework.synch.wsmessages.ActiveSubscriptionRequestType;
import org.bedework.synch.wsmessages.ConnectorInfoType;
import org.bedework.synch.wsmessages.SubscribeResponseType;
import org.bedework.synch.wsmessages.SubscriptionStatusRequestType;
import org.bedework.synch.wsmessages.SubscriptionStatusResponseType;
import org.bedework.synch.wsmessages.SynchDirectionType;
import org.bedework.synch.wsmessages.SynchEndType;
import org.bedework.synch.wsmessages.UnsubscribeRequestType;
import org.bedework.synch.wsmessages.UnsubscribeResponseType;
import org.bedework.util.calendar.diff.XmlIcalCompare;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.ToString;
import org.oasis_open.docs.ws_calendar.ns.soap.AddItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.BaseResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.ComponentSelectionType;
import org.oasis_open.docs.ws_calendar.ns.soap.DeleteItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.ErrorCodeType;
import org.oasis_open.docs.ws_calendar.ns.soap.FetchItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.StatusType;
import org.oasis_open.docs.ws_calendar.ns.soap.TargetDoesNotExistType;
import org.oasis_open.docs.ws_calendar.ns.soap.UpdateItemResponseType;
import org.oasis_open.docs.ws_calendar.ns.soap.UpdateItemType;

public class Synchling
implements Logged {
    private static final Object synchlingIdLock = new Object();
    private static long lastSynchlingId;
    private long synchlingId;
    private SynchEngine syncher;
    private XmlIcalCompare diff;
    private String diffSubid;
    private final int getItemsBatchSize = 20;
    private BwLogger logger = new BwLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Synchling(SynchEngine syncher) {
        this.syncher = syncher;
        Object object = synchlingIdLock;
        synchronized (object) {
            this.synchlingId = ++lastSynchlingId;
        }
    }

    public long getSynchlingId() {
        return this.synchlingId;
    }

    public StatusType handleNotification(Notification<Notification.NotificationItem> note) throws SynchException {
        block13: for (Notification.NotificationItem ni : note.getNotifications()) {
            switch (ni.getAction()) {
                case FullSynch: {
                    if (this.syncher.subscriptionsOnly()) {
                        if (!this.debug()) continue block13;
                        this.debug("Skipping: subscriptions only");
                        continue block13;
                    }
                    StatusType st = this.reSynch(note);
                    if (st == StatusType.OK) continue block13;
                    return st;
                }
                case CopiedEvent: {
                    break;
                }
                case CreatedEvent: {
                    if (this.syncher.subscriptionsOnly()) {
                        if (!this.debug()) continue block13;
                        this.debug("Skipping: subscriptions only");
                        continue block13;
                    }
                    StatusType st = this.addItem(note, ni);
                    if (st == StatusType.OK) continue block13;
                    return st;
                }
                case DeletedEvent: {
                    break;
                }
                case ModifiedEvent: {
                    if (this.syncher.subscriptionsOnly()) {
                        if (!this.debug()) continue block13;
                        this.debug("Skipping: subscriptions only");
                        continue block13;
                    }
                    StatusType st = this.updateItem(note, ni);
                    if (st == StatusType.OK) continue block13;
                    return st;
                }
                case MovedEvent: {
                    break;
                }
                case NewMailEvent: {
                    break;
                }
                case StatusEvent: {
                    break;
                }
                case NewSubscription: {
                    ni.getSubResponse().setStatus(this.subscribe(note, ni));
                    if (ni.getSubResponse().getStatus() != StatusType.OK) {
                        return ni.getSubResponse().getStatus();
                    }
                    ni.getSubResponse().setSubscriptionId(note.getSubscriptionId());
                    this.syncher.setConnectors(note.getSub());
                    this.syncher.reschedule(note.getSub(), true);
                    continue block13;
                }
                case Unsubscribe: {
                    StatusType st = this.unsubscribe(note, ni);
                    if (st == StatusType.OK) continue block13;
                    return st;
                }
                case SubscriptionStatus: {
                    StatusType st = this.subStatus(note, ni);
                    if (st == StatusType.OK) continue block13;
                    return st;
                }
            }
            return StatusType.ERROR;
        }
        note.getSub().setErrorCt(0);
        return StatusType.OK;
    }

    private StatusType subscribe(Notification note, Notification.NotificationItem ni) throws SynchException {
        if (this.debug()) {
            this.debug("new subscription " + note.getSub());
        }
        this.syncher.setConnectors(note.getSub());
        ConnectorInstance cinst = this.syncher.getConnectorInstance(note.getSub(), SynchEndType.A);
        SubscribeResponseType sr = ni.getSubResponse();
        if (!cinst.subscribe(sr)) {
            return sr.getStatus();
        }
        cinst = this.syncher.getConnectorInstance(note.getSub(), SynchEndType.B);
        if (!cinst.subscribe(sr)) {
            return sr.getStatus();
        }
        this.syncher.addSubscription(note.getSub());
        return StatusType.OK;
    }

    private StatusType addItem(Notification note, Notification.NotificationItem ni) throws SynchException {
        IcalendarType ical = ni.getIcal();
        if (ical == null) {
            if (this.debug()) {
                this.debug("No item found");
            }
            return StatusType.ERROR;
        }
        AddItemResponseType air = this.getOtherCinst(note).addItem(ical);
        if (this.debug()) {
            this.debug("Add: status=" + air.getStatus() + " msg=" + air.getMessage());
        }
        return air.getStatus();
    }

    private StatusType updateItem(Notification note, Notification.NotificationItem ni) throws SynchException {
        ResynchInfo fromInfo;
        ResynchInfo toInfo;
        IcalendarType ical = ni.getIcal();
        if (ical == null) {
            if (this.debug()) {
                this.debug("No item found");
            }
            return StatusType.ERROR;
        }
        ConnectorInstance cinst = this.getOtherCinst(note);
        FetchItemResponseType fresp = cinst.fetchItem(ni.getUid());
        if (this.debug()) {
            this.debug("Update: status=" + fresp.getStatus() + " msg=" + fresp.getMessage());
        }
        if (fresp.getStatus() != StatusType.OK) {
            return fresp.getStatus();
        }
        IcalendarType targetIcal = fresp.getIcalendar();
        Subscription sub = note.getSub();
        ResynchInfo ainfo = new ResynchInfo(sub, SynchEndType.A, this.syncher);
        ResynchInfo binfo = new ResynchInfo(sub, SynchEndType.B, this.syncher);
        if (note.getEnd() == SynchEndType.A) {
            toInfo = binfo;
            fromInfo = ainfo;
        } else {
            toInfo = ainfo;
            fromInfo = binfo;
        }
        ComponentSelectionType cst = this.getDiffer(note, fromInfo, toInfo).diff(ical, targetIcal);
        if (cst == null) {
            if (this.debug()) {
                this.debug("No update needed for " + ni.getUid());
            }
            return StatusType.OK;
        }
        UpdateItemType ui = new UpdateItemType();
        ui.setHref(fresp.getHref());
        ui.setChangeToken(fresp.getChangeToken());
        ui.getSelect().add(cst);
        UpdateItemResponseType uir = cinst.updateItem(ui);
        if (this.debug()) {
            this.debug("Update: status=" + uir.getStatus() + " msg=" + uir.getMessage());
        }
        return uir.getStatus();
    }

    private ConnectorInstance getOtherCinst(Notification note) throws SynchException {
        SynchEndType otherEnd = note.getEnd() == SynchEndType.A ? SynchEndType.B : SynchEndType.A;
        return this.syncher.getConnectorInstance(note.getSub(), otherEnd);
    }

    private StatusType unsubscribe(Notification note, Notification.NotificationItem ni) throws SynchException {
        Subscription sub = note.getSub();
        if (sub == null) {
            return StatusType.ERROR;
        }
        if (!this.checkAccess(sub)) {
            this.info("No access for subscription " + sub);
            return StatusType.NO_ACCESS;
        }
        this.syncher.setConnectors(sub);
        ConnectorInstance cinst = this.syncher.getConnectorInstance(sub, SynchEndType.A);
        UnsubscribeRequestType usreq = ni.getUnsubRequest();
        UnsubscribeResponseType usr = ni.getUnsubResponse();
        if (!cinst.unsubscribe(usreq, usr)) {
            this.warn("Unsubscribe end " + SynchEndType.A + " returned false for " + sub);
        }
        if (!(cinst = this.syncher.getConnectorInstance(note.getSub(), SynchEndType.B)).unsubscribe(usreq, usr)) {
            this.warn("Unsubscribe end " + SynchEndType.B + " returned false for " + sub);
        }
        sub.setOutstandingSubscription(null);
        sub.setDeleted(true);
        if (this.debug()) {
            this.debug("Attempt to delete " + sub);
        }
        this.syncher.deleteSubscription(sub);
        if (this.debug()) {
            this.debug("Deleted");
        }
        return StatusType.OK;
    }

    private StatusType subStatus(Notification note, Notification.NotificationItem ni) throws SynchException {
        Subscription sub = note.getSub();
        if (sub == null) {
            return StatusType.ERROR;
        }
        if (!this.checkAccess(sub)) {
            this.info("No access for subscription " + sub);
            return StatusType.NO_ACCESS;
        }
        this.syncher.setConnectors(sub);
        ConnectorInstance cinst = this.syncher.getConnectorInstance(sub, SynchEndType.A);
        SubscriptionStatusRequestType ssreq = ni.getSubStatusReq();
        SubscriptionStatusResponseType ssr = ni.getSubStatusResponse();
        ssr.setSubscriptionId(sub.getSubscriptionId());
        ssr.setPrincipalHref(sub.getOwner());
        ssr.setDirection(sub.getDirection());
        ssr.setLastRefresh(sub.getLastRefresh());
        ssr.setErrorCt(new BigInteger(String.valueOf(sub.getErrorCt())));
        ssr.setEndAConnector(this.getConnectorInfo(sub.getEndAConnectorInfo()));
        ssr.setEndBConnector(this.getConnectorInfo(sub.getEndBConnectorInfo()));
        if (!cinst.validateActiveSubInfo((ActiveSubscriptionRequestType)ssreq, (BaseResponseType)ssr, cinst.getConnector(), cinst.getSubInfo())) {
            return ssr.getStatus();
        }
        return StatusType.OK;
    }

    private ConnectorInfoType getConnectorInfo(SubscriptionConnectorInfo sci) throws SynchException {
        ConnectorInfoType ci = new ConnectorInfoType();
        ci.setConnectorId(sci.getConnectorId());
        ci.setProperties(sci.getAllSynchProperties());
        return ci;
    }

    private StatusType reSynch(Notification note) throws SynchException {
        Subscription sub = note.getSub();
        try {
            boolean bothWays = sub.getDirection() == SynchDirectionType.BOTH_WAYS;
            ResynchInfo ainfo = new ResynchInfo(sub, SynchEndType.A, this.syncher);
            ResynchInfo binfo = new ResynchInfo(sub, SynchEndType.B, this.syncher);
            boolean aChanged = false;
            boolean bChanged = false;
            if (sub.getDirection() == SynchDirectionType.A_TO_B || bothWays) {
                aChanged = ainfo.inst.changed();
            }
            if (sub.getDirection() == SynchDirectionType.B_TO_A || bothWays) {
                bChanged = binfo.inst.changed();
            }
            if (!aChanged && !bChanged) {
                StatusType statusType = StatusType.OK;
                return statusType;
            }
            sub.setMissingTarget(false);
            ainfo.items = this.getItemsMap(ainfo);
            if (ainfo.items == null) {
                if (ainfo.missingTarget) {
                    sub.setMissingTarget(true);
                }
                StatusType statusType = StatusType.ERROR;
                return statusType;
            }
            binfo.items = this.getItemsMap(binfo);
            if (binfo.items == null) {
                if (binfo.missingTarget) {
                    sub.setMissingTarget(true);
                }
                StatusType statusType = StatusType.ERROR;
                return statusType;
            }
            List<SynchInfo> updateInfo = new ArrayList<SynchInfo>();
            if (sub.getDirection() == SynchDirectionType.A_TO_B || bothWays) {
                this.getResynchs(updateInfo, ainfo, binfo);
            }
            if (sub.getDirection() == SynchDirectionType.B_TO_A || bothWays) {
                this.getResynchs(updateInfo, binfo, ainfo);
            }
            if (sub.getDirection() == SynchDirectionType.A_TO_B || bothWays) {
                this.checkDeletes(updateInfo, binfo);
            }
            if (sub.getDirection() == SynchDirectionType.B_TO_A || bothWays) {
                this.checkDeletes(updateInfo, ainfo);
            }
            if (this.debug()) {
                this.debug("---------------- update set ----------------");
                for (SynchInfo si : updateInfo) {
                    this.debug(si.toString());
                }
                this.debug("---------------- end update set ----------------");
            }
            if (updateInfo.size() > 0) {
                Holder unprocessedRes = new Holder();
                if (sub.getDirection() == SynchDirectionType.B_TO_A || bothWays) {
                    while (updateInfo.size() > 0 && this.processUpdates(note, updateInfo, (Holder<List<SynchInfo>>)unprocessedRes, binfo, ainfo)) {
                        updateInfo = (List)unprocessedRes.value;
                    }
                    ainfo.updateCts();
                }
                if (sub.getDirection() == SynchDirectionType.A_TO_B || bothWays) {
                    while (updateInfo.size() > 0 && this.processUpdates(note, updateInfo, (Holder<List<SynchInfo>>)unprocessedRes, ainfo, binfo)) {
                        updateInfo = (List)unprocessedRes.value;
                    }
                    binfo.updateCts();
                }
            }
            if (!sub.getInfo().getDeletionsSuppressed()) {
                if (updateInfo.size() > 0 && sub.getDirection() == SynchDirectionType.B_TO_A || bothWays) {
                    this.processDeletes(note, updateInfo, ainfo);
                }
                if (updateInfo.size() > 0 && sub.getDirection() == SynchDirectionType.A_TO_B || bothWays) {
                    this.processDeletes(note, updateInfo, binfo);
                }
            }
            sub.setErrorCt(0);
            StatusType statusType = StatusType.OK;
            return statusType;
        }
        catch (SynchException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
        finally {
            sub.updateLastRefresh();
            this.syncher.updateSubscription(sub);
            this.syncher.reschedule(sub, false);
        }
    }

    private void getResynchs(List<SynchInfo> updateInfo, ResynchInfo fromInfo, ResynchInfo toInfo) throws SynchException {
        boolean useLastmods = fromInfo.trustLastmod && toInfo.trustLastmod;
        for (ConnectorInstance.ItemInfo fromIi : fromInfo.items.values()) {
            ConnectorInstance.ItemInfo toIi = toInfo.items.get(fromIi.uid);
            if (toIi == null) {
                if (this.debug()) {
                    this.debug("Need to add to end " + toInfo.end + ": uid:" + fromIi.uid);
                }
                SynchInfo si = new SynchInfo(fromIi);
                si.addTo = toInfo.end;
                updateInfo.add(si);
                continue;
            }
            toIi.seen = true;
            boolean update = true;
            if (useLastmods) {
                boolean bl = update = this.cmpLastMods(toIi.lastMod, fromIi.lastMod) < 0;
            }
            if (!update) {
                if (this.debug()) {
                    this.debug("No need to update end " + toInfo.end + ": uid:" + fromIi.uid);
                }
            } else if (this.debug()) {
                this.debug("Need to update end " + toInfo.end + ": uid:" + fromIi.uid);
            }
            SynchInfo si = new SynchInfo(fromIi);
            si.updateEnd = toInfo.end;
            updateInfo.add(si);
        }
    }

    private void checkDeletes(List<SynchInfo> updateInfo, ResynchInfo toInfo) throws SynchException {
        for (ConnectorInstance.ItemInfo ii : toInfo.items.values()) {
            if (ii.seen) continue;
            SynchInfo si = new SynchInfo(ii);
            si.deleteFrom = toInfo.end;
            updateInfo.add(si);
        }
    }

    private Map<String, ConnectorInstance.ItemInfo> getItemsMap(ResynchInfo rinfo) throws SynchException {
        HashMap<String, ConnectorInstance.ItemInfo> items = new HashMap<String, ConnectorInstance.ItemInfo>();
        ConnectorInstance.SynchItemsInfo sii = rinfo.inst.getItemsInfo();
        if (sii.getStatus() != StatusType.OK) {
            ErrorCodeType ecode;
            if (sii.getErrorResponse() != null && sii.getErrorResponse().getError() != null && (ecode = (ErrorCodeType)sii.getErrorResponse().getError().getValue()) instanceof TargetDoesNotExistType) {
                rinfo.missingTarget = true;
            }
            rinfo.sub.setErrorCt(rinfo.sub.getErrorCt() + 1);
            return null;
        }
        for (ConnectorInstance.ItemInfo ii : sii.items) {
            if (this.debug()) {
                this.debug(ii.toString());
            }
            ii.seen = false;
            items.put(ii.uid, ii);
        }
        return items;
    }

    private boolean processUpdates(Notification note, List<SynchInfo> updateInfo, Holder<List<SynchInfo>> unprocessedRes, ResynchInfo fromInfo, ResynchInfo toInfo) throws SynchException {
        ArrayList<SynchInfo> unProcessed;
        boolean callAgain = false;
        unprocessedRes.value = unProcessed = new ArrayList<SynchInfo>();
        ArrayList<String> uids = new ArrayList<String>();
        ArrayList<SynchInfo> sis = new ArrayList<SynchInfo>();
        for (int i = 0; i < updateInfo.size(); ++i) {
            SynchInfo si = updateInfo.get(i);
            if (si.addTo != toInfo.end && si.updateEnd != toInfo.end) {
                unProcessed.add(si);
                continue;
            }
            if (uids.size() == 20) {
                unProcessed.add(si);
                callAgain = true;
                continue;
            }
            uids.add(si.itemInfo.uid);
            sis.add(si);
        }
        if (uids.size() == 0) {
            return false;
        }
        List firs = fromInfo.inst.fetchItems(uids);
        Iterator siit = sis.iterator();
        for (FetchItemResponseType fir : firs) {
            SynchInfo si = (SynchInfo)siit.next();
            if (si.addTo == toInfo.end) {
                IcalendarType filtered = Filters.doFilters(fir.getIcalendar(), fromInfo.getInFilters());
                if (filtered != null) {
                    filtered = Filters.doFilters(filtered, toInfo.getOutFilters());
                }
                AddItemResponseType air = toInfo.inst.addItem(filtered);
                ++toInfo.lastCts.created;
                ++toInfo.totalCts.created;
                if (!this.debug()) continue;
                this.debug("Add: status=" + air.getStatus() + " msg=" + air.getMessage());
                continue;
            }
            if (si.updateEnd == toInfo.end) {
                FetchItemResponseType toFir = toInfo.inst.fetchItem(si.itemInfo.uid);
                if (toFir.getStatus() != StatusType.OK) {
                    this.warn("Unable to fetch destination entity for update: message was " + toFir.getMessage());
                    continue;
                }
                IcalendarType filtered = Filters.doFilters(fir.getIcalendar(), fromInfo.getInFilters());
                if (filtered != null) {
                    filtered = Filters.doFilters(filtered, toInfo.getOutFilters());
                }
                if (filtered == null) {
                    if (!this.debug()) continue;
                    this.debug("Filter removed everything for " + si.itemInfo.uid);
                    continue;
                }
                IcalendarType toFiltered = Filters.doFilters(toFir.getIcalendar(), toInfo.getInFilters());
                ComponentSelectionType cst = this.getDiffer(note, fromInfo, toInfo).diff(filtered, toFiltered);
                if (cst == null) {
                    if (!this.debug()) continue;
                    this.debug("No update needed for " + si.itemInfo.uid);
                    continue;
                }
                if (this.debug()) {
                    this.debug("Update needed for " + si.itemInfo.uid);
                }
                UpdateItemType ui = new UpdateItemType();
                ui.setHref(toFir.getHref());
                ui.setChangeToken(toFir.getChangeToken());
                ui.getSelect().add(cst);
                UpdateItemResponseType uir = toInfo.inst.updateItem(ui);
                if (uir.getStatus() != StatusType.OK) {
                    this.warn("Unable to update destination entity");
                    continue;
                }
                ++toInfo.lastCts.updated;
                ++toInfo.totalCts.updated;
                continue;
            }
            this.warn("Should not get here");
        }
        return callAgain;
    }

    private void processDeletes(Notification note, List<SynchInfo> updateInfo, ResynchInfo toInfo) throws SynchException {
        for (SynchInfo si : updateInfo) {
            if (si.deleteFrom != toInfo.end) continue;
            DeleteItemResponseType deleteItemResponseType = toInfo.inst.deleteItem(si.itemInfo.uid);
        }
    }

    private int cmpLastMods(String calLmod, String exLmod) {
        int exi = 0;
        if (calLmod == null) {
            return -1;
        }
        for (int i = 0; i < 16; ++i) {
            char ex;
            char cal = calLmod.charAt(i);
            if (cal < (ex = exLmod.charAt(exi))) {
                return -1;
            }
            if (cal > ex) {
                return 1;
            }
            if (++exi != 4 && exi != 7 && exi != 12 && exi != 15) continue;
            ++exi;
        }
        return 0;
    }

    private boolean checkAccess(Subscription sub) throws SynchException {
        return true;
    }

    private XmlIcalCompare getDiffer(Notification note, ResynchInfo fromInfo, ResynchInfo toInfo) throws SynchException {
        Subscription sub = note.getSub();
        if (this.diff != null && this.diffSubid != null && this.diffSubid.equals(sub.getSubscriptionId())) {
            return this.diff;
        }
        ArrayList<Object> skipList = new ArrayList<Object>(XmlIcalCompare.defaultSkipList);
        Filters.addDifferSkipItems(skipList, fromInfo.getInFilters());
        Filters.addDifferSkipItems(skipList, toInfo.getOutFilters());
        this.diffSubid = sub.getSubscriptionId();
        this.diff = new XmlIcalCompare(skipList, this.syncher.getTzGetter());
        return this.diff;
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }

    private static class ResynchInfo {
        Subscription sub;
        SynchEndType end;
        boolean trustLastmod;
        ConnectorInstance inst;
        Map<String, ConnectorInstance.ItemInfo> items;
        BaseSubscriptionInfo.CrudCts lastCts;
        BaseSubscriptionInfo.CrudCts totalCts;
        final SubscriptionConnectorInfo connInfo;
        List<Filter> inFilters;
        List<Filter> outFilters;
        boolean missingTarget;

        ResynchInfo(Subscription sub, SynchEndType end, SynchEngine syncher) throws SynchException {
            Connector c;
            this.sub = sub;
            this.end = end;
            if (end == SynchEndType.A) {
                c = sub.getEndAConn();
                this.connInfo = sub.getEndAConnectorInfo();
            } else {
                c = sub.getEndBConn();
                this.connInfo = sub.getEndBConnectorInfo();
            }
            this.trustLastmod = c.getTrustLastmod();
            this.inst = syncher.getConnectorInstance(sub, end);
            this.lastCts = new BaseSubscriptionInfo.CrudCts();
            this.inst.setLastCrudCts(this.lastCts);
            this.totalCts = this.inst.getTotalCrudCts();
        }

        void updateCts() throws SynchException {
            this.inst.setLastCrudCts(this.lastCts);
            this.inst.setTotalCrudCts(this.totalCts);
        }

        List<Filter> getInFilters() throws SynchException {
            if (this.inFilters == null) {
                this.inFilters = this.connInfo.getInputFilters(this.sub);
            }
            return this.inFilters;
        }

        List<Filter> getOutFilters() throws SynchException {
            if (this.outFilters == null) {
                this.outFilters = this.connInfo.getOutputFilters(this.sub);
            }
            return this.outFilters;
        }
    }

    private static class SynchInfo {
        public ConnectorInstance.ItemInfo itemInfo;
        public SynchEndType addTo = SynchEndType.NONE;
        public SynchEndType updateEnd = SynchEndType.NONE;
        public SynchEndType deleteFrom = SynchEndType.NONE;
        public boolean conflict;

        public SynchInfo(ConnectorInstance.ItemInfo itemInfo) {
            this.itemInfo = itemInfo;
        }

        public String toString() {
            ToString ts = new ToString((Object)this);
            ts.append((Object)this.itemInfo);
            return ts.toString();
        }
    }
}

