/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.synch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.bedework.synch.Synchling;
import org.bedework.synch.shared.Stat;
import org.bedework.synch.shared.SynchEngine;
import org.bedework.synch.shared.exception.SynchException;
import org.bedework.synch.shared.exception.SynchTimeout;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;
import org.bedework.util.misc.ToString;

public class SynchlingPool
implements Logged {
    private SynchEngine syncher;
    private ArrayBlockingQueue<Synchling> pool;
    private Map<Long, Synchling> active = new HashMap<Long, Synchling>();
    private long timeout;
    private long waitTimes;
    private long gets;
    private long getSynchlingFailures;
    private BwLogger logger = new BwLogger();

    public void start(SynchEngine syncher, int size, long timeout) {
        this.syncher = syncher;
        this.timeout = timeout;
        this.resize(size);
    }

    public void stop() {
        long maxWait = 90000L;
        long startTime = System.currentTimeMillis();
        long delay = 5000L;
        while (this.getActiveCt() > 0L) {
            if (System.currentTimeMillis() - startTime > maxWait) {
                this.warn("**************************************************");
                this.warn("Synch shutdown completed with " + this.getActiveCt() + " active synchlings");
                this.warn("**************************************************");
                break;
            }
            this.info("**************************************************");
            this.info("Synch shutdown - " + this.getActiveCt() + " active synchlings");
            this.info("**************************************************");
            try {
                this.wait(delay);
            }
            catch (InterruptedException ie) {
                maxWait = 0L;
            }
        }
    }

    public void resize(int size) {
        ArrayBlockingQueue<Synchling> oldPool = this.getPool();
        this.pool = new ArrayBlockingQueue(size);
        int oldSize = 0;
        if (oldPool != null) {
            oldSize = oldPool.size();
            this.pool.drainTo(oldPool, Math.max(size, oldSize));
        }
        while (size > oldSize) {
            this.pool.add(new Synchling(this.syncher));
            ++oldSize;
        }
    }

    public void setTimeout(long val) {
        this.timeout = val;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getActiveCt() {
        return this.active.size();
    }

    public long getWaitTimes() {
        return this.waitTimes;
    }

    public long getGets() {
        return this.gets;
    }

    public long getGetSynchlingFailures() {
        return this.getSynchlingFailures;
    }

    public int getCurrentMaxSize() {
        ArrayBlockingQueue<Synchling> thePool = this.pool;
        if (thePool == null) {
            return 0;
        }
        return thePool.size();
    }

    public int getCurrentAvailable() {
        ArrayBlockingQueue<Synchling> thePool = this.pool;
        if (thePool == null) {
            return 0;
        }
        return thePool.remainingCapacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Synchling s) throws SynchException {
        Map<Long, Synchling> map = this.active;
        synchronized (map) {
            this.active.remove(s.getSynchlingId());
        }
        this.getPool().offer(s);
    }

    public Synchling get() throws SynchException {
        return this.get(true);
    }

    public Synchling getNoException() throws SynchException {
        return this.get(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Synchling get(boolean throwOnFailure) throws SynchException {
        Synchling s = null;
        ++this.gets;
        long st = System.currentTimeMillis();
        try {
            s = this.getPool().poll(this.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            throw new SynchException(t);
        }
        this.waitTimes += System.currentTimeMillis() - st;
        if (s == null) {
            ++this.getSynchlingFailures;
            if (throwOnFailure) {
                throw new SynchTimeout("Synchling pool wait");
            }
        } else {
            Map<Long, Synchling> map = this.active;
            synchronized (map) {
                this.active.put(s.getSynchlingId(), s);
            }
        }
        return s;
    }

    private synchronized ArrayBlockingQueue<Synchling> getPool() {
        return this.pool;
    }

    public List<Stat> getStats() {
        ArrayList<Stat> stats = new ArrayList<Stat>();
        stats.add(new Stat("synchling get timeout", this.getTimeout()));
        stats.add(new Stat("synchling active", this.getActiveCt()));
        stats.add(new Stat("synchling gets", this.getGets()));
        stats.add(new Stat("synchling waitTimes", this.getWaitTimes()));
        stats.add(new Stat("synchling get failures", this.getGetSynchlingFailures()));
        stats.add(new Stat("synchling currentMaxSize", (long)this.getCurrentMaxSize()));
        stats.add(new Stat("synchling currentAvailable", (long)this.getCurrentAvailable()));
        return stats;
    }

    public String toString() {
        ToString ts = new ToString((Object)this);
        return ts.append("timeout", Long.valueOf(this.getTimeout())).append("gets", Long.valueOf(this.getGets())).newLine().append("waitTimes", Long.valueOf(this.getWaitTimes())).append("getSynchlingFailures", Long.valueOf(this.getGetSynchlingFailures())).newLine().append("currentMaxSize", this.getCurrentMaxSize()).append("currentAvailable", this.getCurrentAvailable()).toString();
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

